/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.test.context.task.resource;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.test.EGFCoreTestPlugin;
import org.eclipse.egf.fprod.producer.manager.ITaskManager;
import org.eclipse.egf.fprod.producer.manager.TaskManagerFactory;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fprod.Task;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;

public class ContextTaskResource
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextTaskResource.class);
    }

    public void testInvokeH1() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.task.h1/task_h1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextTaskResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextTaskResource.assertTrue((String)NLS.bind((String)"We Expected to find an ''Task'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        Activity activity = (Activity)eObject;
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        IActivityManager manager = producer.createActivityManager(activity);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextTaskResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                return;
            }
        }
    }

    public void testContractH1() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.task.h1/task_h1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextTaskResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextTaskResource.assertTrue((String)NLS.bind((String)"We Expected to find an ''Task'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Task));
        Task task = (Task)eObject;
        ITaskManager manager = TaskManagerFactory.createProductionManager((Task)task);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextTaskResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                return;
            }
        }
        Float amount = (Float)manager.getProductionContext().getOutputValue((Object)"amount", Float.class);
        ContextTaskResource.assertEquals((Object)new Float("1050"), (Object)amount);
    }

    public void testOutputContractClassNotTheSameH1() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.task.h1/task_h1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextTaskResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextTaskResource.assertTrue((String)NLS.bind((String)"We Expected to find an ''Task'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Task));
        Task task = (Task)eObject;
        ITaskManager manager = TaskManagerFactory.createProductionManager((Task)task);
        GeneratorAdapterFactory defaultValue = null;
        try {
            try {
                manager.initializeContext();
                defaultValue = (GeneratorAdapterFactory)manager.getProductionContext().getOutputValue((Object)"generatorAdapterFactory", GeneratorAdapterFactory.class);
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextTaskResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextTaskResource.fail((String)e.getMessage());
                return;
            }
        }
        ContextTaskResource.assertNotSame((Object)manager.getProductionContext().getOutputValue((Object)"generatorAdapterFactory", GeneratorAdapterFactory.class), (Object)defaultValue);
    }
}

