/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.InvocationContext;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationContext;
import org.eclipse.egf.producer.context.IFactoryComponentProductionContext;
import org.eclipse.egf.producer.context.IOrchestrationProductionContext;
import org.eclipse.egf.producer.internal.context.ModelElementProductionContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrchestrationProductionContext
extends ModelElementProductionContext<OrchestrationContext>
implements IOrchestrationProductionContext {
    public OrchestrationProductionContext(Orchestration element, ProjectBundleSession projectBundleSession) {
        super((ModelElement)element, projectBundleSession);
    }

    public OrchestrationProductionContext(IFactoryComponentProductionContext parent, Orchestration element, ProjectBundleSession projectBundleSession) {
        super(parent, (ModelElement)element, projectBundleSession);
    }

    @Override
    public Orchestration getElement() {
        return (Orchestration)super.getElement();
    }

    @Override
    public IFactoryComponentProductionContext getParent() {
        return (IFactoryComponentProductionContext)super.getParent();
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        OrchestrationContext orchestrationContext = this.getOrchestrationContext(key, (Collection<OrchestrationContext>)this.getElement().getOrchestrationContexts());
        InvocationContext invocationContext = (InvocationContext)key;
        Class valueType = null;
        if (invocationContext.getFactoryComponentExposedContract() != null) {
            if (this.getParent() != null && invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.OUT) {
                valueType = this.getParent().getInputValueType(invocationContext);
            }
        } else {
            if (orchestrationContext == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
            }
            ProductionContext.Data data = (ProductionContext.Data)this._inputDatas.get(orchestrationContext);
            if (data != null) {
                valueType = data.getType();
            }
        }
        return valueType;
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        OrchestrationContext orchestrationContext = this.getOrchestrationContext(key, (Collection<OrchestrationContext>)this.getElement().getOrchestrationContexts());
        InvocationContext invocationContext = (InvocationContext)key;
        Object value = null;
        if (invocationContext.getFactoryComponentExposedContract() != null) {
            if (this.getParent() != null && invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.OUT) {
                value = this.getParent().getInputValue(invocationContext, clazz);
            }
        } else {
            if (orchestrationContext == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
            }
            ProductionContext.Data data = (ProductionContext.Data)this._inputDatas.get(orchestrationContext);
            if (data != null) {
                value = this.getValue(orchestrationContext, clazz, data);
            }
        }
        return (R)value;
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        this.getOrchestrationContext(key, (Collection<OrchestrationContext>)this.getElement().getOrchestrationContexts());
        InvocationContext invocationContext = (InvocationContext)key;
        Class valueType = null;
        if (invocationContext.getFactoryComponentExposedContract() != null && this.getParent() != null && invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.IN) {
            valueType = this.getParent().getOutputValueType(invocationContext);
        }
        return valueType;
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        this.getOrchestrationContext(key, (Collection<OrchestrationContext>)this.getElement().getOrchestrationContexts());
        InvocationContext invocationContext = (InvocationContext)key;
        Object value = null;
        if (invocationContext.getFactoryComponentExposedContract() != null && this.getParent() != null && invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.IN) {
            value = this.getParent().getOutputValue(invocationContext, clazz);
        }
        return (R)value;
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        this.getOrchestrationContext(key, (Collection<OrchestrationContext>)this.getElement().getOrchestrationContexts());
        InvocationContext invocationContext = (InvocationContext)key;
        if (invocationContext.getFactoryComponentExposedContract() != null && this.getParent() != null && invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.IN) {
            this.getParent().setOutputValue(invocationContext, value);
        }
    }

    private OrchestrationContext getOrchestrationContext(Object key, Collection<OrchestrationContext> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
        }
        if (!(key instanceof InvocationContext)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{InvocationContext.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        OrchestrationContext orchestrationContext = null;
        for (OrchestrationContext innerOrchestrationContext : keys) {
            if (!innerOrchestrationContext.getInvocationContexts().contains(key)) continue;
            orchestrationContext = innerOrchestrationContext;
            break;
        }
        return orchestrationContext;
    }
}

