/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.domain.ResourceLoadedListener;
import org.eclipse.egf.pattern.ui.editors.pages.ImplementationPage;
import org.eclipse.egf.pattern.ui.editors.pages.OverviewPage;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.pages.SpecificationPage;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;

public class PatternEditor
extends FormEditor
implements ResourceLoadedListener.ResourceUser,
IEditingDomainProvider {
    protected IUndoContext undoContext;
    private TransactionalEditingDomain editingDomain;
    private final ResourceLoadedListener.ResourceListener resourceListener = new ResourceLoadedListener.ResourceListener(){

        public void resourceMoved(Resource resource, URI newURI) {
        }

        public void resourceDeleted(Resource resource) {
            PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PatternEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternEditor.this, false);
                }
            });
        }

        public void resourceChanged(Resource resource) {
            for (PatternEditorPage page : PatternEditor.this.pages) {
                page.rebind();
            }
            PatternEditor.this.addPatternChangeAdapter();
            PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PatternEditor.this.firePropertyChange(257);
                }
            });
        }
    };
    private final List<PatternEditorPage> pages = new ArrayList<PatternEditorPage>();
    AdapterImpl refresher = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (FcorePackage.Literals.MODEL_ELEMENT__NAME.equals(msg.getFeature())) {
                PatternEditor.this.setPartName((String)msg.getNewValue());
            }
        }
    };
    private final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
            switch (event.getEventType()) {
                case 4: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)PatternEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext(PatternEditor.this.undoContext);
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                    break;
                }
                case 9: 
                case 10: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                }
            }
        }
    };

    public PatternEditor() {
        this.initializeEditingDomain();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)ResourceLoadedListener.RESOURCE_MANAGER.createSaveOperation(this, this.editingDomain));
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        }
        catch (InvocationTargetException exception) {
            Activator.getDefault().logError(exception.getTargetException());
        }
        catch (Exception exception) {
            Activator.getDefault().logError(exception);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    protected void initializeEditingDomain() {
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.egf.pattern.ui.editors.PatternEditingDomain");
        this.undoContext = new ObjectUndoContext((Object)this, "undoContext label");
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
    }

    private IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        super.init(site, editorInput);
        ResourceLoadedListener.RESOURCE_MANAGER.addObserver(this);
        this.addPatternChangeAdapter();
    }

    private void addPatternChangeAdapter() {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            pattern.eAdapters().add((Object)this.refresher);
            this.setPartName(pattern.getName());
        }
    }

    private void removePatternChangeAdapter() {
        Pattern pattern = this.getPattern();
        if (pattern != null && pattern.eAdapters().contains((Object)this.refresher)) {
            pattern.eAdapters().remove((Object)this.refresher);
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        if (this.getResource() == null) {
            return false;
        }
        boolean modified = this.getResource().isModified();
        return modified;
    }

    protected void addPages() {
        try {
            this.addPage(new OverviewPage(this));
            this.addPage(new SpecificationPage(this));
            this.addPage(new ImplementationPage(this));
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }

    private Pattern getPattern() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getPattern();
    }

    public Resource getResource() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getResource();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void dispose() {
        ResourceLoadedListener.RESOURCE_MANAGER.removeObserver(this);
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.getOperationHistory().dispose(this.undoContext, true, true, true);
        this.removePatternChangeAdapter();
        super.dispose();
    }

    public void addPage(PatternEditorPage page) throws PartInitException {
        this.pages.add(page);
        this.addPage((IFormPage)page);
    }

    public ResourceLoadedListener.ResourceListener getListener() {
        return this.resourceListener;
    }

    public static void openEditor(IWorkbenchPage page, Pattern pattern) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        Resource resource = pattern.eResource();
        try {
            PatternEditorInput input = new PatternEditorInput(resource, pattern.getID());
            PatternEditor cfr_ignored_0 = (PatternEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.egf.pattern.ui.editors.PatternEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

