/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.adapter;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.selector.PatternValidationDelegateClientSelector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;

public class LiveValidationContentAdapter
extends EContentAdapter {
    private ILiveValidator validator = null;
    private Control control;
    private IMessageManager mmng;
    private String key;
    private Pattern pattern;

    public LiveValidationContentAdapter(Control control, IMessageManager mmng, String key, Pattern pattern) {
        this.control = control;
        this.mmng = mmng;
        this.key = key;
        this.pattern = pattern;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        super.notifyChanged(notification);
        if (!(notification.getFeature() instanceof EAttribute)) {
            return;
        }
        if (notifier instanceof PatternParameter || notifier instanceof PatternVariable) {
            this.checkTableInput(notifier);
            return;
        }
        if (this.validator == null) {
            this.validator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        }
        if (Messages.PatternUIHelper_key_NonPatternEmptyName.equals(this.key) && notifier instanceof Pattern && this.control instanceof Text && this.isNameChange(notification)) {
            PatternValidationDelegateClientSelector.running = true;
            IStatus status = this.validator.validate(notification);
            this.executeValidate(status);
            PatternValidationDelegateClientSelector.running = false;
        }
    }

    private void executeValidate(IStatus status) {
        if (this.control != null && !this.control.isDisposed()) {
            PatternUIHelper.setErrorMessage(status, this.mmng, this.key, this.control);
        }
    }

    private void checkTableInput(Object notifier) {
        Object data;
        Table table;
        if (this.control != null && !this.control.isDisposed() && this.control instanceof Table && (table = (Table)this.control).getItemCount() > 0 && (data = table.getItem(0).getData()).getClass().equals(notifier.getClass())) {
            PatternUIHelper.validationContent(this.mmng, (EObject)this.pattern, this.key, this.control);
            return;
        }
    }

    private boolean isNameChange(Notification notification) {
        EAttribute eAttribute;
        Object feature = notification.getFeature();
        return feature instanceof EAttribute && "name".equals((eAttribute = (EAttribute)feature).getName());
    }
}

