/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards.pages;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.SuperPatternCall;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.dialogs.PatternElementSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.MethodLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.PatternSelectionLabelProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OrchestrationWizard;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseKindPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ParameterMatchingPage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseCallPage
extends WizardPage {
    private CallTypeEnum selectKind;
    private CallTypeEnum oldKind = CallTypeEnum.Add;
    private Pattern pattern;
    private TableViewer parentTableViewer;
    private TableViewer childTableViewer;
    private Call selectCall;
    private Label title;
    private Text text;
    private Label varParaLabel;
    private Object eidtItem;
    private boolean isFirst = true;

    public ChooseCallPage(Pattern pattern, ISelection selection, Object eidtItem) {
        super(Messages.ChooseCallPage_title);
        this.setTitle(Messages.ChooseCallPage_title);
        this.setDescription(Messages.ChooseCallPage_description);
        this.pattern = pattern;
        this.eidtItem = eidtItem;
    }

    public void createControl(Composite parent) {
        this.createCallControl(parent);
        this.setPageComplete(false);
    }

    private void createCallControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.title = new Label(container, 0);
        GridData gd = new GridData(768);
        this.title.setLayoutData((Object)gd);
        this.createPatternsMethodsArea(container);
        this.createVariablesArea(container);
        this.setControl((Control)container);
    }

    private void createPatternsMethodsArea(Composite container) {
        this.text = new Text(container, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 550;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ChooseCallPage.this.selectKind != CallTypeEnum.SUPERPATTERN_CALL) {
                    ChooseCallPage.this.checkListAreaExist(ChooseCallPage.this.text.getText());
                }
            }
        });
        Label label = new Label(container, 0);
        label.setText(Messages.ChooseCallPage_label_text);
        Table listTable = new Table(container, 2816);
        gd = new GridData(1808);
        gd.heightHint = 60;
        listTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(listTable, 0);
        tableColumn.setWidth(500);
        this.parentTableViewer = new TableViewer(listTable);
        this.parentTableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        this.parentTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseCallPage.this.checkParentTableSelect();
                ChooseCallPage.this.setParameterMatchingCall(ChooseCallPage.this.selectCall);
                if (ChooseCallPage.this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL && ChooseCallPage.this.isPageComplete()) {
                    ChooseCallPage.this.checkChildTableSelect();
                }
            }
        });
        this.parentTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChooseCallPage.this.selectKind == CallTypeEnum.METHOD_CALL || ChooseCallPage.this.selectKind == CallTypeEnum.PATTERN_CALL) {
                    ChooseCallPage.this.getSelectionContent();
                    ChooseCallPage.this.setParameterMatchingCall(ChooseCallPage.this.selectCall);
                    ChooseCallPage.this.getWizard().performFinish();
                    WizardDialog wizardDialog = (WizardDialog)ChooseCallPage.this.getWizard().getContainer();
                    wizardDialog.close();
                } else {
                    ChooseCallPage.this.checkChildTableSelect();
                    ChooseCallPage.this.PatterninjectedCallDoubleClick();
                }
            }
        });
    }

    private void createVariablesArea(Composite container) {
        this.varParaLabel = new Label(container, 0);
        GridData gd = new GridData(768);
        this.varParaLabel.setLayoutData((Object)gd);
        this.varParaLabel.setText(Messages.ChooseCallPage_patternInjectCall_title);
        Table listTable = new Table(container, 2816);
        gd = new GridData(1808);
        gd.heightHint = 60;
        listTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(listTable, 0);
        tableColumn.setWidth(500);
        this.childTableViewer = new TableViewer(listTable);
        this.childTableViewer.setLabelProvider((IBaseLabelProvider)new PatternSelectionLabelProvider());
        this.childTableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        this.childTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseCallPage.this.checkChildTableSelect();
                if (ChooseCallPage.this.isPageComplete()) {
                    ChooseCallPage.this.checkParentTableSelect();
                }
            }
        });
        this.childTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChooseCallPage.this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL) {
                    ChooseCallPage.this.checkParentTableSelect();
                    ChooseCallPage.this.PatterninjectedCallDoubleClick();
                }
            }
        });
    }

    private void PatterninjectedCallDoubleClick() {
        if (this.isPageComplete()) {
            this.getSelectionContent();
            this.getWizard().performFinish();
            WizardDialog wizardDialog = (WizardDialog)this.getWizard().getContainer();
            wizardDialog.close();
        }
    }

    private void setDefaultSelectValue() {
        if (this.eidtItem != null) {
            if (this.selectKind == CallTypeEnum.METHOD_CALL && this.eidtItem instanceof MethodCall) {
                MethodCall call = (MethodCall)this.eidtItem;
                PatternMethod called = call.getCalled();
                this.setSelectValue(called, null);
            } else if (this.selectKind == CallTypeEnum.PATTERN_CALL && this.eidtItem instanceof PatternCall) {
                PatternCall call = (PatternCall)this.eidtItem;
                Pattern called = call.getCalled();
                this.setSelectValue(called, null);
            } else if (this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL && this.eidtItem instanceof PatternInjectedCall) {
                PatternInjectedCall call = (PatternInjectedCall)this.eidtItem;
                Pattern called = call.getCalled();
                PatternVariable context = call.getContext();
                this.setSelectValue(called, context);
            } else if (this.selectKind == CallTypeEnum.SUPERPATTERN_CALL) {
                boolean cfr_ignored_0 = this.eidtItem instanceof SuperPatternCall;
            }
            this.setParameterMatchingCall(this.eidtItem);
        }
    }

    private void setSelectValue(Object called, Object context) {
        if (called != null) {
            TableItem[] parentItems = this.parentTableViewer.getTable().getItems();
            int i = 0;
            while (i < parentItems.length) {
                Object currentData = parentItems[i].getData();
                if (currentData.equals(called)) {
                    this.parentTableViewer.getTable().select(i);
                    this.setTextValue(called);
                    if (this.selectKind == CallTypeEnum.METHOD_CALL || this.selectKind == CallTypeEnum.PATTERN_CALL) {
                        this.checkParentTableSelect();
                        return;
                    }
                    if (this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL) {
                        this.setChildTableSelectValue(called, context);
                        return;
                    }
                }
                ++i;
            }
        }
    }

    private void setTextValue(Object called) {
        if (called instanceof PatternMethod) {
            PatternMethod patternMethod = (PatternMethod)called;
            this.text.setText(patternMethod.getName());
        } else if (called instanceof Pattern) {
            Pattern pattern = (Pattern)called;
            this.text.setText(pattern.getName());
        }
    }

    private void setChildTableSelectValue(Object called, Object context) {
        if (context != null) {
            TableItem[] childItems = this.childTableViewer.getTable().getItems();
            int i = 0;
            while (i < childItems.length) {
                Object currentData = childItems[i].getData();
                if (currentData.equals(context)) {
                    this.childTableViewer.getTable().select(i);
                    this.checkChildTableSelect();
                    return;
                }
                ++i;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.selectKind = this.getPreviousPage() != null ? ((ChooseKindPage)this.getPreviousPage()).getKind() : ((OrchestrationWizard)this.getWizard()).getDefaultKind();
            this.updateTable(this.selectKind);
        }
        super.setVisible(visible);
        if (this.isFirst) {
            this.setDefaultSelectValue();
            this.isFirst = false;
        }
    }

    private void updateTable(CallTypeEnum kind) {
        if (kind == CallTypeEnum.METHOD_CALL) {
            if (kind != this.oldKind) {
                this.parentTableViewer.setLabelProvider((IBaseLabelProvider)new MethodLabelProvider(PatternUIHelper.getPatternParentMethodsNameList(this.pattern)));
                this.parentTableViewer.setSorter(new ViewerSorter(Collator.getInstance(Locale.ENGLISH)));
                this.updateTableInput(this.getMethods(), null, true, false);
            }
            this.title.setText(Messages.ChooseCallPage_methodCall_title);
        } else {
            this.parentTableViewer.setLabelProvider((IBaseLabelProvider)new PatternSelectionLabelProvider());
        }
        if (kind == CallTypeEnum.PATTERN_CALL) {
            if (kind != this.oldKind) {
                this.updateTableInput(this.getPatterns(), null, true, false);
            }
            this.title.setText(Messages.ChooseCallPage_patternCall_title);
        }
        if (kind == CallTypeEnum.PATTERNINJECTED_CALL) {
            if (kind != this.oldKind) {
                this.updateTableInput(this.getPatterns(), this.getVariables(this.pattern), true, true);
            }
            this.title.setText(Messages.ChooseCallPage_patternCall_title);
        }
        if (kind == CallTypeEnum.SUPERPATTERN_CALL) {
            this.updateTableInput(null, null, false, false);
            if (kind != this.oldKind) {
                this.title.setText(Messages.ChooseCallPage_superPatternCall_title);
            }
        }
        this.oldKind = kind;
    }

    private void redrawControl(boolean exclude) {
        GridData labelLayoutData = (GridData)this.varParaLabel.getLayoutData();
        labelLayoutData.exclude = exclude;
        this.varParaLabel.setVisible(!exclude);
        Table table = this.childTableViewer.getTable();
        GridData tableLayoutData = (GridData)table.getLayoutData();
        tableLayoutData.exclude = exclude;
        table.setVisible(!exclude);
        this.layout((Control)table);
    }

    private void layout(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        if (control instanceof Composite) {
            ((Composite)control).layout();
        }
        this.layout((Control)control.getParent());
    }

    private void updateTableInput(List<?> parentTableInput, List<?> childTableInput, boolean parentTableEnable, boolean childTableEnable) {
        this.parentTableViewer.setInput(null);
        this.parentTableViewer.setInput(parentTableInput);
        this.childTableViewer.setInput(childTableInput);
        this.parentTableViewer.getTable().setEnabled(parentTableEnable);
        this.childTableViewer.getTable().setEnabled(childTableEnable);
        this.redrawControl(!childTableEnable);
        this.text.setText("");
        if (this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL) {
            this.checkChildTableSelect();
        }
        this.checkParentTableSelect();
    }

    private void checkParentTableSelect() {
        int selectionIndex = this.parentTableViewer.getTable().getSelectionIndex();
        if (selectionIndex == -1) {
            String errorMessage = Messages.ChooseCallPage_no_call_selected_error_message;
            this.updateMessage(errorMessage);
        } else {
            this.updateMessage(null);
            this.setPatternCalleeForMatch(selectionIndex);
        }
    }

    private void setPatternCalleeForMatch(int index) {
        if (this.selectKind == CallTypeEnum.PATTERN_CALL) {
            Pattern pattern = (Pattern)this.parentTableViewer.getElementAt(index);
            ((ParameterMatchingPage)this.getNextPage()).setPatternCallee(pattern);
        }
    }

    private void checkChildTableSelect() {
        int selectionIndex = this.childTableViewer.getTable().getSelectionIndex();
        if (selectionIndex == -1) {
            String errorMessage = Messages.ChooseCallPage_no_variable_selected_error_message;
            this.updateMessage(errorMessage);
        } else {
            this.updateMessage(null);
        }
    }

    private void updateMessage(String message) {
        this.setMessage(message, 3);
        if ("".equals(message) || message == null) {
            this.getSelectionContent();
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private List<PatternMethod> getMethods() {
        return PatternUIHelper.getAllUseablePatternMethods(this.pattern);
    }

    private List<Pattern> getPatterns() {
        Set patterns = PatternHelper.TRANSACTIONNAL_COLLECTOR.getAllPatterns();
        ArrayList<Pattern> parentMethods = new ArrayList<Pattern>();
        parentMethods.addAll(patterns);
        return parentMethods;
    }

    private List<PatternVariable> getVariables(Pattern pattern) {
        EList allVariables = pattern.getAllVariables();
        return allVariables;
    }

    private void checkListAreaExist(String name) {
        if (this.getListAreaDisplay(name).size() <= 0) {
            this.setPageComplete(false);
        }
    }

    private List<?> getListAreaDisplay(String name) {
        List<Object> input = new ArrayList();
        switch (this.selectKind) {
            case METHOD_CALL: {
                input = this.getMethods();
                break;
            }
            case PATTERN_CALL: {
                input = this.getPatterns();
                break;
            }
            case PATTERNINJECTED_CALL: {
                input = this.getPatterns();
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<Object> callsNew = new ArrayList<Object>();
        if (!"".equals(name)) {
            String currentName = "";
            for (Object currentItemData : input) {
                if (this.selectKind == CallTypeEnum.METHOD_CALL) {
                    if (currentItemData instanceof PatternMethod) {
                        currentName = ((PatternMethod)currentItemData).getName().toLowerCase();
                    }
                } else if ((this.selectKind == CallTypeEnum.PATTERN_CALL || this.selectKind == CallTypeEnum.PATTERNINJECTED_CALL) && currentItemData instanceof Pattern) {
                    currentName = ((Pattern)currentItemData).getName().toLowerCase();
                }
                if (!PatternElementSelectionDialog.searchContainer(currentName, name)) continue;
                callsNew.add(currentItemData);
            }
        } else {
            callsNew.addAll(input);
        }
        this.parentTableViewer.setInput(callsNew);
        return callsNew;
    }

    protected void getSelectionContent() {
        int selectParentTableIndex = this.parentTableViewer.getTable().getSelectionIndex();
        if (selectParentTableIndex >= 0) {
            Object selectParentItem = this.parentTableViewer.getElementAt(selectParentTableIndex);
            switch (this.selectKind) {
                case METHOD_CALL: {
                    PatternMethod patternMethod = (PatternMethod)selectParentItem;
                    MethodCall methodCall = PatternFactory.eINSTANCE.createMethodCall();
                    methodCall.setCalled(patternMethod);
                    this.selectCall = methodCall;
                    return;
                }
                case PATTERN_CALL: {
                    Pattern patternKind_1 = (Pattern)selectParentItem;
                    PatternCall patternCall = PatternFactory.eINSTANCE.createPatternCall();
                    patternCall.setCalled(patternKind_1);
                    this.selectCall = patternCall;
                    return;
                }
                case PATTERNINJECTED_CALL: {
                    Pattern patternKind_2 = (Pattern)selectParentItem;
                    PatternInjectedCall patternInjectedCall = PatternFactory.eINSTANCE.createPatternInjectedCall();
                    patternInjectedCall.setCalled(patternKind_2);
                    int selectChildTableIndex = this.childTableViewer.getTable().getSelectionIndex();
                    Object selectChildItem = this.childTableViewer.getElementAt(selectChildTableIndex);
                    if (selectChildItem instanceof PatternVariable) {
                        PatternVariable patternVariable = (PatternVariable)selectChildItem;
                        patternInjectedCall.setContext(patternVariable);
                    }
                    this.selectCall = patternInjectedCall;
                    return;
                }
                case SUPERPATTERN_CALL: {
                    return;
                }
            }
        }
    }

    private void setParameterMatchingCall(Object call) {
        if (this.selectKind == CallTypeEnum.PATTERN_CALL && call != null && call instanceof PatternCall) {
            PatternCall patternCall = (PatternCall)call;
            ((ParameterMatchingPage)this.getNextPage()).setPatternCall(patternCall);
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectKind == CallTypeEnum.PATTERN_CALL) {
            return super.getNextPage();
        }
        return null;
    }

    public Call getChooseCall() {
        if (this.selectKind == CallTypeEnum.PATTERN_CALL) {
            return ((ParameterMatchingPage)this.getNextPage()).getPatternCall();
        }
        return this.selectCall;
    }
}

