/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.adapter.RefresherAdapter;
import org.eclipse.egf.pattern.ui.editors.models.QueryContent;
import org.eclipse.egf.pattern.ui.editors.validation.EMFvalidator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternUIHelper {
    public static List<String> getPatternParentMethodsNameList(Pattern pattern) {
        Pattern parent;
        ArrayList<String> parentMethods = new ArrayList<String>();
        Pattern pattern2 = parent = pattern == null ? null : pattern.getSuperPattern();
        if (parent != null) {
            for (PatternMethod patternMethod : parent.getMethods()) {
                String name = patternMethod.getName();
                parentMethods.add(name);
            }
        }
        return parentMethods;
    }

    public static List<PatternMethod> getAllUseablePatternMethods(Pattern pattern) {
        ArrayList<PatternMethod> parentMethods = new ArrayList<PatternMethod>();
        HashSet<String> names = new HashSet<String>();
        if (pattern != null) {
            for (PatternMethod patternMethod : pattern.getAllMethods()) {
                String name = patternMethod.getName();
                if (PatternFactory.isSpecialMethod((String)name) || names.contains(name)) continue;
                parentMethods.add(patternMethod);
                names.add(name);
            }
        }
        return parentMethods;
    }

    public static List<String> getUseablePatternMethodsNameList(Pattern pattern) {
        ArrayList<String> parentMethods = new ArrayList<String>();
        if (pattern != null) {
            for (PatternMethod patternMethod : pattern.getMethods()) {
                String name = patternMethod.getName();
                if (PatternFactory.isSpecialMethod((String)name)) continue;
                parentMethods.add(name);
            }
        }
        return parentMethods;
    }

    public static void addAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
            PatternUIHelper.addChildAdapter(object, refresher);
        }
    }

    public static void removeAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
            PatternUIHelper.removeChildAdapter(object, refresher);
        }
    }

    public static void addChildAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
        }
    }

    public static void removeChildAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
        }
    }

    public static void addIntoAdapters(EList<Adapter> eAdapters, AdapterImpl refresher) {
        if (!eAdapters.contains((Object)refresher)) {
            eAdapters.add((Object)refresher);
        }
    }

    public static void removeFromeAdapters(EList<Adapter> eAdapters, AdapterImpl refresher) {
        if (eAdapters.contains((Object)refresher)) {
            eAdapters.remove((Object)refresher);
        }
    }

    public static void addAdapterForPattern(Pattern pattern, AdapterImpl liveValidationContentAdapter) {
        if (pattern != null) {
            EList eAdapters = pattern.eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, liveValidationContentAdapter);
        }
    }

    public static void removeAdapterForPattern(Pattern pattern, AdapterImpl adapter) {
        if (pattern != null) {
            EList eAdapters = pattern.eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, adapter);
        }
    }

    public static void validationContent(IMessageManager mmng, EObject object, String key, Control control) {
        if (control != null && !control.isDisposed()) {
            IStatus status = EMFvalidator.batchValidate(object, key);
            PatternUIHelper.setErrorMessage(status, mmng, key, control);
        }
    }

    public static void setErrorMessage(IStatus status, IMessageManager mmng, String key, Control control) {
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                status = status.getChildren()[0];
            }
            if (status.getCode() == 1 && "org.eclipse.egf.pattern.ui.PatternNameNotEmpty".equals(key) || status.getCode() == 2 && "org.eclipse.egf.pattern.ui.PatternParameterNameNotEmpty".equals(key) || status.getCode() == 3 && "org.eclipse.egf.pattern.ui.PatternVariableNameNotEmpty".equals(key)) {
                mmng.addMessage((Object)key, status.getMessage(), null, 3, control);
            }
        } else {
            mmng.removeMessage((Object)key, control);
        }
    }

    public static boolean isRenameDisable(PatternMethod element) {
        return PatternFactory.isSpecialMethod((String)element.getName());
    }

    public static LiveValidationContentAdapter addValidationAdapeter(IMessageManager mmng, Pattern pattern, String key, Control control) {
        LiveValidationContentAdapter liveValidationContentAdapter = new LiveValidationContentAdapter(control, mmng, key, pattern);
        PatternUIHelper.addAdapterForPattern(pattern, (AdapterImpl)liveValidationContentAdapter);
        PatternUIHelper.validationContent(mmng, (EObject)pattern, key, control);
        return liveValidationContentAdapter;
    }

    public static void addAdapterForNewItem(TableViewer tableViewer, Object newItem) {
        RefresherAdapter refresher = new RefresherAdapter(tableViewer);
        PatternUIHelper.addAdapter(newItem, refresher);
    }

    public static void addEMFValidationAfterRemove(IMessageManager mmng, Pattern pattern, String key, Control control, LiveValidationContentAdapter liveValidationContentAdapter) {
        liveValidationContentAdapter = new LiveValidationContentAdapter(control, mmng, key, pattern);
        PatternUIHelper.addAdapterForPattern(pattern, (AdapterImpl)liveValidationContentAdapter);
    }

    public static boolean hasDuplicateKey(List<QueryContent> queryContents) {
        if (queryContents != null) {
            int i = 0;
            while (i < queryContents.size()) {
                String key = queryContents.get(i).getKey();
                int j = i + 1;
                while (j < queryContents.size()) {
                    String currentKey = queryContents.get(j).getKey();
                    if (currentKey.equals(key)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }
}

