/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal.keys;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.gpg.PGPSecretKeyParser;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.OpenedPGPKeyData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.keys.ObjectIds;

public final class SecretKeys {
    private static final int MAX_SEXPR_NESTING = 20;

    private SecretKeys() {
    }

    public static PGPSecretKey readSecretKey(InputStream in, PGPDigestCalculatorProvider calculatorProvider, PassphraseSupplier passphraseSupplier, PGPPublicKey publicKey) throws IOException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        OpenedPGPKeyData data;
        Throwable throwable = null;
        Object var6_6 = null;
        try (BufferedInputStream keyIn = new BufferedInputStream(in);){
            data = PGPSecretKeyParser.parse((InputStream)keyIn, (int)20);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JcePBEProtectionRemoverFactory decryptor = null;
        if (SecretKeys.isProtected(data)) {
            decryptor = new JcePBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider);
        }
        switch (publicKey.getAlgorithm()) {
            case 22: 
            case 27: {
                ExtendedPGPSecretKey secret = data.getKeyData(null, calculatorProvider, (PBEProtectionRemoverFactory)decryptor, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), 20);
                PGPPublicKey pubKeyRead = secret.getPublicKey();
                int algoRead = pubKeyRead.getAlgorithm();
                if (algoRead != 22 && algoRead != 27) {
                    throw new PGPException(BCText.get().keyAlgorithmMismatch);
                }
                ECPublicBCPGKey ec1 = (ECPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                ECPublicBCPGKey ec2 = (ECPublicBCPGKey)pubKeyRead.getPublicKeyPacket().getKey();
                if (!ObjectIds.match(ec1.getCurveOID(), ec2.getCurveOID()) || !ec1.getEncodedPoint().equals(ec2.getEncodedPoint())) {
                    throw new PGPException(MessageFormat.format(BCText.get().keyMismatch, ec1.getCurveOID(), ec1.getEncodedPoint(), ec2.getCurveOID(), ec2.getEncodedPoint()));
                }
                return secret;
            }
        }
        return data.getKeyData(publicKey, calculatorProvider, (PBEProtectionRemoverFactory)decryptor, null, 20);
    }

    private static boolean isProtected(OpenedPGPKeyData data) {
        return 2 == SExprParser.getProtectionType((String)data.getKeyExpression().getString(0));
    }

    public static interface PassphraseSupplier {
        public char[] getPassphrase() throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException;
    }
}

