/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.dsf;

import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.dsf.GnuMcuDebuggerCommandsService;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.preferences.DefaultPreferences;
import org.osgi.framework.BundleContext;

public class DebuggerCommands
extends GnuMcuDebuggerCommandsService {
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();

    public DebuggerCommands(DsfSession session, ILaunchConfiguration lc, String mode) {
        super(session, lc, mode, true);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        String otherInits = ((String)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherCommands", (Object)this.fDefaultPreferences.getGdbClientCommands())).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuResetCommands(List<String> commandsList) {
        IStatus status = this.addFirstResetCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        status = this.addLoadSymbolsCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        if (((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && !((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.doDebugInRam", (Object)this.fDefaultPreferences.getQemuDebugInRam())).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuStartCommands(List<String> commandsList) {
        IStatus status = this.addStartRestartCommands(true, commandsList);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addFirstResetCommands(List<String> commandsList) {
        if (((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.doFirstReset", (Object)this.fDefaultPreferences.getQemuDoInitialReset())).booleanValue()) {
            String commandStr = "monitor system_reset ";
            commandsList.add(commandStr);
            commandStr = "";
            commandsList.add(commandStr);
        }
        String otherInits = ((String)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.otherInitCommands", (Object)this.fDefaultPreferences.getQemuInitOther())).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            otherInits = StringUtils.duplicateBackslashes((String)otherInits);
        }
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        IStatus status;
        if (doReset && ((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.doSecondReset", (Object)this.fDefaultPreferences.getQemuDoPreRunReset())).booleanValue()) {
            String commandStr = "monitor system_reset ";
            commandsList.add(commandStr);
            commandStr = "";
            commandsList.add(commandStr);
        }
        if (((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && ((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.doDebugInRam", (Object)this.fDefaultPreferences.getQemuDebugInRam())).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        String userCmd = ((String)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.otherRunCommands", (Object)this.fDefaultPreferences.getQemuPreRunOther())).trim();
        userCmd = DebugUtils.resolveAll((String)userCmd, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            userCmd = StringUtils.duplicateBackslashes((String)userCmd);
        }
        DebugUtils.addMultiLine((String)userCmd, commandsList);
        this.addSetPcCommands(commandsList);
        this.addStopAtCommands(commandsList);
        if (((Boolean)DebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.qemu.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        return Status.OK_STATUS;
    }
}

