/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdClusterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdFieldDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdPeripheralDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdRegisterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterArrayElementVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterArrayVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterRepetitionVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralGroupVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralPath;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterArrayElementVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterArrayVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldRepetitionVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterRepetitionVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralTopVMNode;
import org.eclipse.embedcdt.packs.core.tree.Node;

public abstract class PeripheralTreeVMNode
implements IRegister,
Comparable<PeripheralTreeVMNode> {
    protected PeripheralGroupVMNode fPeripheral;
    protected PeripheralTreeVMNode fParent;
    protected ArrayList<PeripheralTreeVMNode> fChildren;
    protected SvdDMNode fDMNode;
    protected PeripheralPath fPath;
    protected String fName;
    private boolean fHasChanged;
    protected int fFadingLevel;

    public PeripheralTreeVMNode(PeripheralTreeVMNode parent, SvdDMNode dmNode) {
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        this.fChildren = null;
        this.fDMNode = dmNode;
        assert (this.fDMNode != null);
        this.fPath = null;
        this.fHasChanged = false;
        this.fFadingLevel = 0;
        this.fName = this.fDMNode.getDisplayName();
        assert (this.fName != null);
        if (this.fDMNode.getNode().getPackType() == Node.PACK_TYPE_XPACK && this.fName.indexOf("%s") < 0) {
            if (this.fDMNode.isArray()) {
                this.fName = String.valueOf(this.fName) + "[%s]";
            } else if (this.fDMNode.isRepetition()) {
                this.fName = String.valueOf(this.fName) + "%s";
            }
        }
        PeripheralTreeVMNode node = this;
        while (node.getParent() != null) {
            node = (PeripheralTreeVMNode)node.getParent();
        }
        this.fPeripheral = (PeripheralGroupVMNode)node;
        assert (this.fPeripheral != null);
    }

    public void dispose() {
        this.fParent = null;
        this.fChildren = null;
        if (this.fDMNode != null) {
            this.fDMNode.dispose();
            this.fDMNode = null;
        }
        this.fPath = null;
    }

    protected void addChild(PeripheralTreeVMNode child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(child);
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.prepareChildren();
        }
        Object[] children = this.fChildren.toArray(new PeripheralTreeVMNode[this.fChildren.size()]);
        Arrays.sort(children);
        return children;
    }

    public Object getParent() {
        return this.fParent;
    }

    public boolean hasChildren() {
        if (this.fChildren == null) {
            this.prepareChildren();
        }
        return !this.fChildren.isEmpty();
    }

    public String getModelIdentifier() {
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return null;
    }

    public ILaunch getLaunch() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IValue getValue() throws DebugException {
        return null;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fHasChanged;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return !this.isReadOnly();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IRegisterGroup getRegisterGroup() throws DebugException {
        return this.fPeripheral;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public boolean isField() {
        return this.fDMNode instanceof SvdFieldDMNode;
    }

    public boolean isRegister() {
        return this.fDMNode instanceof SvdRegisterDMNode;
    }

    public boolean isCluster() {
        return this.fDMNode instanceof SvdClusterDMNode;
    }

    public boolean isPeripheral() {
        return this.fDMNode instanceof SvdPeripheralDMNode;
    }

    public PeripheralPath getPath() {
        if (this.fPath == null) {
            PeripheralTreeVMNode parent = (PeripheralTreeVMNode)this.getParent();
            if (parent != null) {
                return new PeripheralPath(parent.getPath(), new PeripheralPath(this.fName));
            }
            return new PeripheralPath(this.fName);
        }
        return this.fPath;
    }

    public String getQualifiedName() {
        return this.getPath().toString();
    }

    public String getDescription() {
        return this.fDMNode.getDescription();
    }

    public BigInteger getThisBigAddressOffset() {
        return this.fDMNode.getBigAddressOffset();
    }

    public BigInteger getPeripheralBigAddressOffset() {
        PeripheralTreeVMNode parent;
        BigInteger offset = this.getThisBigAddressOffset();
        if (offset == null) {
            System.out.println("");
        }
        if ((parent = (PeripheralTreeVMNode)this.getParent()) != null) {
            BigInteger b = parent.getPeripheralBigAddressOffset();
            if (b == null) {
                System.out.println();
            }
            offset = offset.add(b);
        }
        return offset;
    }

    public BigInteger getBigAbsoluteAddress() {
        BigInteger peripheralBaseAddress;
        try {
            peripheralBaseAddress = ((PeripheralTopVMNode)this.getRegisterGroup()).getBigAbsoluteAddress();
        }
        catch (DebugException debugException) {
            peripheralBaseAddress = BigInteger.ZERO;
        }
        BigInteger offset = this.getPeripheralBigAddressOffset();
        return peripheralBaseAddress.add(offset);
    }

    public BigInteger getBigSize() {
        return this.fDMNode.getBigSizeBytes();
    }

    public abstract String getDisplayNodeType();

    public abstract String getImageName();

    public String getAccess() {
        return this.fDMNode.getAccess();
    }

    public String getReadAction() {
        return this.fDMNode.getReadAction();
    }

    public boolean isWriteOnly() {
        return this.fDMNode.isWriteOnly();
    }

    public boolean isReadOnly() {
        return this.fDMNode.isReadOnly();
    }

    public boolean isReadAllowed() {
        return this.fDMNode.isReadAllowed();
    }

    public boolean hasReadAction() {
        return this.fDMNode.hasReadAction();
    }

    public String getDisplayAddress() {
        BigInteger bigAddress = this.getBigAbsoluteAddress();
        if (bigAddress != null) {
            return String.format("0x%08X", bigAddress.longValue());
        }
        return null;
    }

    public String getDisplayOffset() {
        long value = this.getPeripheralBigAddressOffset().longValue();
        if (value < 65536L) {
            return String.format("0x%04X", value);
        }
        return String.format("0x%08X", value);
    }

    public abstract String getDisplaySize();

    public String getDisplayValue() {
        return null;
    }

    protected PeripheralTopVMNode getPeripheral() {
        try {
            return (PeripheralTopVMNode)this.getRegisterGroup();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public boolean isArray() {
        return this.fDMNode.isArray();
    }

    public boolean isRepetition() {
        return this.fDMNode.isRepetition();
    }

    public int getArraySize() {
        return this.fDMNode.getArraySize();
    }

    private void prepareChildren() {
        if (this.fChildren != null) {
            return;
        }
        this.fChildren = new ArrayList();
        SvdObjectDMNode[] svdChildren = this.fDMNode.getChildren();
        assert (svdChildren != null);
        int i = 0;
        while (i < svdChildren.length) {
            SvdDMNode child = (SvdDMNode)svdChildren[i];
            if (child.isArray()) {
                this.processArray(child);
            } else if (child.isRepetition()) {
                this.processRepetitions(child);
            } else if (child instanceof SvdClusterDMNode) {
                new PeripheralClusterVMNode(this, child);
            } else if (child instanceof SvdRegisterDMNode) {
                new PeripheralRegisterVMNode(this, child);
            } else if (child instanceof SvdFieldDMNode) {
                new PeripheralRegisterFieldVMNode(this, child);
            } else {
                Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
            }
            ++i;
        }
    }

    private void processRepetitions(SvdDMNode child) {
        BigInteger increment = child.getBigRepeatIncrement();
        String[] indices = child.getRepetitionSubstitutions();
        if (indices.length == 0) {
            Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " has no repetitions"));
            return;
        }
        if (child instanceof SvdClusterDMNode) {
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < indices.length) {
                new PeripheralClusterRepetitionVMNode(this, child, indices[i], offset);
                if (increment != null) {
                    offset = offset.add(increment);
                }
                ++i;
            }
        } else if (child instanceof SvdRegisterDMNode) {
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < indices.length) {
                new PeripheralRegisterRepetitionVMNode(this, child, indices[i], offset);
                assert (increment != null);
                assert (increment.compareTo(BigInteger.ZERO) > 0);
                offset = offset.add(increment);
                ++i;
            }
        } else if (child instanceof SvdFieldDMNode) {
            int offset = 0;
            int intIncrement = increment.intValue();
            int i = 0;
            while (i < indices.length) {
                new PeripheralRegisterFieldRepetitionVMNode(this, child, indices[i], offset);
                assert (intIncrement > 0);
                offset += intIncrement;
                ++i;
            }
        } else {
            Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
        }
    }

    private void processArray(SvdDMNode child) {
        BigInteger increment = child.getBigRepeatIncrement();
        if (child instanceof SvdClusterDMNode) {
            PeripheralClusterArrayVMNode arrayNode = new PeripheralClusterArrayVMNode(this, child);
            arrayNode.substituteRepetition("");
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < child.getArraySize()) {
                new PeripheralClusterArrayElementVMNode(arrayNode, child, i, offset);
                if (increment != null) {
                    offset = offset.add(increment);
                }
                ++i;
            }
        } else if (child instanceof SvdRegisterDMNode) {
            PeripheralRegisterArrayVMNode arrayNode = new PeripheralRegisterArrayVMNode(this, child);
            arrayNode.substituteRepetition("");
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < child.getArraySize()) {
                new PeripheralRegisterArrayElementVMNode(arrayNode, child, i, offset);
                assert (increment != null);
                assert (increment.compareTo(BigInteger.ZERO) > 0);
                offset = offset.add(increment);
                ++i;
            }
        } else {
            Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
        }
    }

    protected void substituteRepetition(String str) {
        if (this.fName.indexOf("%s") >= 0) {
            if (str.isEmpty() && this.fName.indexOf("[%s]") < 0) {
                str = "[]";
            }
            this.fName = String.format(this.fName, str);
        }
    }

    public void setChanged(boolean hasChanged) {
        this.fHasChanged = hasChanged;
        if (this.fHasChanged) {
            this.setFadingLevel(3);
        }
    }

    public int getFadingLevel() {
        return this.fFadingLevel;
    }

    public void setFadingLevel(int level) {
        this.fFadingLevel = level;
        if (this.fFadingLevel > 0 && Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralTreeVMNode.setFadingLevel() " + this.fName + " " + this.fFadingLevel);
        }
    }

    public void decrementFadingLevel() {
        if (this.fFadingLevel > 0) {
            this.setFadingLevel(this.fFadingLevel - 1);
        }
        if (this.fChildren != null) {
            for (PeripheralTreeVMNode node : this.fChildren) {
                node.decrementFadingLevel();
            }
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayNodeType() + ":" + this.getQualifiedName() + "]";
    }

    @Override
    public int compareTo(PeripheralTreeVMNode comp) {
        return this.fDMNode.compareTo(comp.fDMNode);
    }
}

