/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.embedcdt.core.EclipseUtils;

public class XpackUtils {
    public static boolean hasPackageJson(IProject project) {
        if (project == null) {
            return false;
        }
        IPath projectPath = project.getLocation();
        File packageFile = projectPath.append("package.json").toFile();
        if (!packageFile.exists()) {
            return false;
        }
        return !packageFile.isDirectory();
    }

    public static IPath getRepoBasePath() {
        Map<String, String> env = System.getenv();
        if (EclipseUtils.isMacOSX()) {
            String homeFolder = env.get("HOME");
            Path path = new Path(homeFolder);
            return path.append("/Library");
        }
        if (EclipseUtils.isLinux()) {
            String homeFolder = env.get("HOME");
            Path path = new Path(homeFolder);
            return path.append("/opt");
        }
        if (EclipseUtils.isWindows()) {
            String homeFolder = env.get("APPDATA");
            Path path = new Path(homeFolder);
            return path;
        }
        return null;
    }

    public static IPath[] getRepoBasePaths() {
        Map<String, String> env = System.getenv();
        if (EclipseUtils.isMacOSX()) {
            IPath[] paths = new IPath[1];
            String homeFolder = env.get("HOME");
            paths[0] = new Path(homeFolder).append("/Library");
            return paths;
        }
        if (EclipseUtils.isLinux()) {
            IPath[] paths = new IPath[2];
            String homeFolder = env.get("HOME");
            paths[0] = new Path(homeFolder).append("/.local");
            paths[1] = new Path(homeFolder).append("/opt");
            return paths;
        }
        if (EclipseUtils.isWindows()) {
            IPath[] paths = new IPath[1];
            String homeFolder = env.get("APPDATA");
            paths[0] = new Path(homeFolder);
            return paths;
        }
        return null;
    }

    public static IPath getSysRepoBasePath() {
        Map<String, String> env = System.getenv();
        if (EclipseUtils.isMacOSX()) {
            Path path = new Path("/opt");
            return path;
        }
        if (EclipseUtils.isLinux()) {
            Path path = new Path("/opt");
            return path;
        }
        if (EclipseUtils.isWindows()) {
            String progFolder = env.get("ProgramFiles");
            Path path = new Path(progFolder);
            return path;
        }
        return null;
    }

    public static IPath[] getSysRepoBasePaths() {
        Map<String, String> env = System.getenv();
        if (EclipseUtils.isMacOSX()) {
            IPath[] paths = new IPath[]{new Path("/opt")};
            return paths;
        }
        if (EclipseUtils.isLinux()) {
            IPath[] paths = new IPath[]{new Path("/opt")};
            return paths;
        }
        if (EclipseUtils.isWindows()) {
            IPath[] paths = new IPath[1];
            String progFolder = env.get("ProgramFiles");
            paths[0] = new Path(progFolder);
            return paths;
        }
        return null;
    }

    public static IPath getRepoPath() {
        Path repoPath;
        Map<String, String> env = System.getenv();
        String folder = env.get("XPACKS_REPO_FOLDER");
        if (folder != null && (repoPath = new Path(folder)).toFile().isDirectory()) {
            return repoPath;
        }
        IPath[] paths = XpackUtils.getRepoBasePaths();
        if (paths != null) {
            IPath[] iPathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                repoPath = path.append("xPacks");
                if (repoPath.toFile().isDirectory()) {
                    return repoPath;
                }
                ++n2;
            }
        }
        return paths[0].append("xPacks");
    }

    public static IPath getSysRepoPath() {
        Path repoPath;
        Map<String, String> env = System.getenv();
        String folder = env.get("XPACKS_SYSTEM_FOLDER");
        if (folder != null && (repoPath = new Path(folder)).toFile().isDirectory()) {
            return repoPath;
        }
        IPath[] paths = XpackUtils.getSysRepoBasePaths();
        if (paths != null) {
            IPath[] iPathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                repoPath = path.append("xPacks");
                if (repoPath.toFile().isDirectory()) {
                    return repoPath;
                }
                ++n2;
            }
        }
        return paths[0].append("xPacks");
    }

    public static IPath getPackPath(String packName) {
        IPath repoPath = XpackUtils.getRepoPath();
        String[] arr = packName.split("[/]", 2);
        if (arr.length == 1) {
            return repoPath.append(arr[0]);
        }
        return repoPath.append(arr[0]).append(arr[1]);
    }

    public static IPath getSysPackPath(String packName) {
        IPath repoPath = XpackUtils.getSysRepoPath();
        String[] arr = packName.split("[/]", 2);
        if (arr.length == 1) {
            return repoPath.append(arr[0]);
        }
        return repoPath.append(arr[0]).append(arr[1]);
    }

    public static String[] getPackVersions(String[] packNames) {
        final LinkedHashSet versions = new LinkedHashSet();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath packagePath;
                IPath path = new Path(dir.getAbsolutePath()).append(name);
                if (path.toFile().isDirectory() && (packagePath = path.append("package.json")).toFile().isFile()) {
                    if (".link".equals(name)) {
                        versions.add("current");
                    } else {
                        versions.add(name);
                    }
                    return true;
                }
                return false;
            }
        };
        String[] stringArray = packNames;
        int n = packNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packName = stringArray[n2];
            IPath packPath = XpackUtils.getPackPath(packName);
            File folder = packPath.toFile();
            if (folder.isDirectory()) {
                folder.listFiles(filter);
            }
            if ((folder = (packPath = XpackUtils.getSysPackPath(packName)).toFile()).isDirectory()) {
                folder.listFiles(filter);
            }
            ++n2;
        }
        if (versions.isEmpty()) {
            return new String[0];
        }
        LinkedList list = new LinkedList(versions);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String lhs, String rhs) {
                if (lhs.equals("current")) {
                    return -1;
                }
                if (rhs.equals("current")) {
                    return 1;
                }
                Version vlhs = Version.valueOf(lhs);
                Version vrhs = Version.valueOf(rhs);
                return vrhs.compareTo(vlhs);
            }
        });
        return list.toArray(new String[list.size()]);
    }
}

