/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdRegisterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdUtils;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralTreeVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralValue;

public class PeripheralRegisterVMNode
extends PeripheralTreeVMNode {
    protected BigInteger fBitMask = null;
    protected PeripheralValue fValue = new PeripheralValue();

    public PeripheralRegisterVMNode(PeripheralTreeVMNode parent, SvdDMNode dmNode) {
        super(parent, dmNode);
        this.fValue.setDisplayFormatForBitWidth(this.getWidthBits());
    }

    @Override
    public void dispose() {
        this.fValue = null;
        super.dispose();
    }

    @Override
    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    @Override
    public boolean supportsValueModification() {
        return super.supportsValueModification();
    }

    public PeripheralValue getPeripheralValue() {
        return this.fValue;
    }

    public String getValueString() {
        IValue value = null;
        try {
            value = this.getValue();
        }
        catch (DebugException debugException) {}
        if (value instanceof PeripheralValue) {
            try {
                return value.getValueString();
            }
            catch (DebugException debugException) {}
        }
        return "";
    }

    @Override
    public void setValue(String value) throws DebugException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("setValue(" + value + ")");
        }
    }

    @Override
    public void setValue(IValue value) throws DebugException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("setValue(" + value + ")");
        }
        if (value instanceof PeripheralValue) {
            this.fValue = (PeripheralValue)value;
        } else {
            this.setValue(value.getValueString());
        }
        this.setChanged(true);
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return PeripheralValue.isNumeric(expression);
    }

    @Override
    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean setNumericValue(String value) {
        block4: {
            this.setChanged(false);
            if (this.verifyValue(value)) break block4;
            return false;
        }
        try {
            BigInteger bigValue = SvdUtils.parseScaledNonNegativeBigInteger(value);
            bigValue = bigValue.and(this.getBitMask());
            this.update(bigValue);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DebugException debugException) {}
        return true;
    }

    protected void update(BigInteger newValue) {
        boolean sameValue = this.getPeripheralValue().getBigValue().equals(newValue);
        if (!sameValue) {
            long offset = this.getPeripheralBigAddressOffset().longValue();
            this.getPeripheral().getMemoryBlock().writePeripheralRegister(offset, this.getWidthBytes(), newValue);
            this.getPeripheral().getMemoryBlock().updatePeripheralRenderingValues();
        }
    }

    public void setValue(BigInteger newValue) {
        this.setChanged(this.getPeripheralValue().update(newValue));
        Object[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof PeripheralRegisterFieldVMNode) {
                ((PeripheralRegisterFieldVMNode)children[i]).updateFieldValueFromParent();
            }
            ++i;
        }
    }

    protected BigInteger getBitMask() {
        if (this.fBitMask == null) {
            this.fBitMask = BigInteger.ONE;
            this.fBitMask = this.fBitMask.shiftLeft(this.getWidthBits());
            this.fBitMask = this.fBitMask.subtract(BigInteger.ONE);
        }
        return this.fBitMask;
    }

    @Override
    public String getDisplayNodeType() {
        return "Register";
    }

    @Override
    public String getImageName() {
        return "register_obj";
    }

    @Override
    public String getDisplaySize() {
        int width = this.getWidthBits();
        if (width == 1) {
            return "1 bit";
        }
        if (width > 1) {
            return String.format("%d bits", width);
        }
        return null;
    }

    @Override
    public String getDisplayValue() {
        String readAction = this.getReadAction();
        if (!readAction.isEmpty()) {
            return "(read " + readAction + ")";
        }
        String value = this.getValueString();
        if (!value.isEmpty()) {
            return value;
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public String getDisplayResetValue() {
        if (this.fDMNode instanceof SvdRegisterDMNode) {
            String resetValue = ((SvdRegisterDMNode)this.fDMNode).getResetValue();
            if (resetValue.isEmpty()) {
                return null;
            }
            String resetMask = ((SvdRegisterDMNode)this.fDMNode).getResetMask();
            if (resetValue.isEmpty()) {
                return resetValue;
            }
            return String.valueOf(resetValue) + "/" + resetMask;
        }
        return null;
    }

    public void forceReadRegister() {
        if (this.isField()) {
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("unimplemented forceReadRegister()");
        }
    }

    public int getOffsetBits() {
        return 0;
    }

    public int getWidthBits() {
        return ((SvdRegisterDMNode)this.fDMNode).getWidthBits();
    }

    public int getWidthBytes() {
        return (this.getWidthBits() + 7) / 8;
    }
}

