/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui;

import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.embedcdt.internal.ui.Activator;
import org.eclipse.embedcdt.ui.SystemUIJob;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchWindow;

public class EclipseUiUtils {
    public static void openExternalBrowser(URL url) throws PartInitException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
    }

    public static void openExternalFile(IPath path) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    public static void openFileWithInternalEditor(IPath path) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    public static IProject getSelectedProject() {
        Object firstElement;
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IProject project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
            return project;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchPage getActivePage(IWorkbenchPart part) {
        return part.getSite().getWorkbenchWindow().getActivePage();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void openError(final String title, final String message, final Exception e) {
        SystemUIJob uiJob = new SystemUIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String msg = message;
                if (e != null) {
                    msg = "\n" + e.getMessage();
                }
                MessageDialog.openError((Shell)EclipseUiUtils.getShell(), (String)title, (String)msg);
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public static void clearStatusMessage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setErrorMessage("");
                }
            }
        });
    }

    public static void showStatusMessage(final String message) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println(message);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setMessage(message);
                }
            }
        });
    }

    public static void showStatusErrorMessage(final String message) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println(message);
        }
        Activator.log(message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setErrorMessage("  " + message);
                }
            }
        });
    }
}

