/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.web.servlets;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.parsley.config.Configurator;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Application {
    private static Application application;
    private Map<String, Object> id2objectMap;
    private Map<Object, String> objec2idtMap;
    private Injector injector;
    private ResourceSet resourceSet;
    private Display display;
    private Shell shell;
    @Inject
    private Configurator configurator;
    @Inject
    private ResourceLoader resourceLoader;

    private Application() {
    }

    public static synchronized Application getInstance(HttpServletRequest request) {
        if (application == null) {
            application = new Application();
            Application.application.id2objectMap = new HashMap<String, Object>();
            Application.application.objec2idtMap = new HashMap<Object, String>();
            Application.application.injector = (Injector)request.getSession().getServletContext().getAttribute(Injector.class.getName());
            Application.application.injector.injectMembers((Object)application);
            Application.application.resourceSet = new ResourceSetImpl();
            Application.application.display = new Display();
            Application.application.shell = new Shell(Application.application.display);
        }
        return application;
    }

    public synchronized Resource getResource(String entity) throws IOException {
        URI uri = this.configurator.createResourceURI((Object)entity);
        if (uri != null) {
            Resource resource = this.resourceLoader.getResource(this.resourceSet, uri);
            return resource;
        }
        return null;
    }

    public synchronized String put(Object object) {
        String id = this.objec2idtMap.get(object);
        if (id == null) {
            UUID uid = UUID.randomUUID();
            id = uid.toString();
            this.id2objectMap.put(id, object);
            this.objec2idtMap.put(object, id);
        }
        return id;
    }

    public synchronized Object get(String id) {
        return this.id2objectMap.get(id);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public synchronized ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public synchronized ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Display getDisplay() {
        return this.display;
    }
}

