/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    public long handle;
    Tree parent;
    String[] strings;
    Image[] images;
    Font font;
    Font[] cellFont;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int[] cellBackground;
    int[] cellForeground;

    public TreeItem(Tree parent, int style) {
        this(parent, style, 0L, -65534L, 0L);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, style, 0L, TreeItem.findPrevious(parent, index), 0L);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, style, parentItem.handle, -65534L, 0L);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, style, parentItem.handle, TreeItem.findPrevious(parentItem, index), 0L);
    }

    TreeItem(Tree parent, int style, long hParent, long hInsertAfter, long hItem) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, hParent, hInsertAfter, hItem);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static long findPrevious(TreeItem parentItem, int index) {
        if (parentItem == null) {
            return 0L;
        }
        if (index < 0) {
            SWT.error(6);
        }
        if (index == 0) {
            return -65535L;
        }
        return 0L;
    }

    static long findPrevious(Tree parent, int index) {
        if (parent == null) {
            return 0L;
        }
        if (index < 0) {
            SWT.error(6);
        }
        if (index == 0) {
            return -65535L;
        }
        return 0L;
    }
}

