/*******************************************************************************
 * Copyright (c) 2015 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Vincenzo Caselli - Initial contribution and API
 * 
 *******************************************************************************/
package org.eclipse.swt.events;

import org.eclipse.swt.widgets.Event;

/**
 * Instances of this class are sent as a result of operations being performed on
 * shells.
 *
 * @see ShellListener
 * @see <a href="http://www.eclipse.org/swt/">Sample code and further
 *      information</a>
 */

public final class ShellEvent extends TypedEvent {

	/**
	 * A flag indicating whether the operation should be allowed. Setting this
	 * field to <code>false</code> will cancel the operation.
	 */
	public boolean doit;

	static final long serialVersionUID = 3257569490479888441L;

	/**
	 * Constructs a new instance of this class based on the information in the
	 * given untyped event.
	 *
	 * @param e
	 *            the untyped event containing the information
	 */
	public ShellEvent(Event e) {
		super(e);
		this.doit = e.doit;
	}

	/**
	 * Returns a string containing a concise, human-readable description of the
	 * receiver.
	 *
	 * @return a string representation of the event
	 */
	@Override
	public String toString() {
		String string = super.toString();
		return string.substring(0, string.length() - 1) // remove trailing '}'
				+ " doit=" + doit + "}";
	}
}
