/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.editor;

import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class EmfaticAutoEditStrategy
implements IAutoEditStrategy {
    EmfaticEditor _editor = null;
    private IPreferenceStore preferenceStore;

    public EmfaticAutoEditStrategy(EmfaticEditor editor) {
        this._editor = editor;
        this.preferenceStore = EmfaticUIPlugin.getDefault().getPreferenceStore();
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text == null) {
            return;
        }
        if (c.text.endsWith("{")) {
            this.smartBrace(d, c);
        } else if (c.text.endsWith("\"")) {
            this.insert(c, "", "\"");
        } else if (c.text.endsWith("[")) {
            c.text = String.valueOf(c.text) + "*]";
        }
    }

    private void smartBrace(IDocument d, DocumentCommand c) {
        if (!this.preferenceStore.getBoolean("booleanPreference")) {
            return;
        }
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        String computedIndent = this.computeIndent(d, c);
        String beforeCaret = "\r\n" + computedIndent + "\t";
        String afterCaret = "\r\n" + computedIndent + "}";
        this.insert(c, beforeCaret, afterCaret);
    }

    private void insert(DocumentCommand c, String beforeCaret, String afterCaret) {
        StringBuffer buf = new StringBuffer(c.text);
        buf.append(beforeCaret);
        c.caretOffset = c.offset + beforeCaret.toCharArray().length + 1;
        c.shiftsCaret = false;
        buf.append(afterCaret);
        c.length = 0;
        c.text = buf.toString();
    }

    private String computeIndent(IDocument d, DocumentCommand c) {
        String res = "";
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            if (end > start) {
                res = d.get(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {}
        return res;
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }
}

