/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.connectionmanager;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.SessionManager;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerTest {
    @Test
    public void testSessionProviderExtensionPointNoPrios() {
        ESExtensionElement noPrio1 = SessionManagerTest.createExtensionElement(null);
        ESExtensionElement noPrio2 = SessionManagerTest.createExtensionElement(null);
        ESExtensionPoint testConfiguration = SessionManagerTest.createExtensionPoint(Arrays.asList(noPrio1, noPrio2));
        ESExtensionElement result = SessionManager.analyseUsersessionExtensionPoint((ESExtensionPoint)testConfiguration);
        Assert.assertSame((Object)noPrio1, (Object)result);
    }

    @Test
    public void testSessionProviderExtensionPointOnePrio() {
        ESExtensionElement noPrio1 = SessionManagerTest.createExtensionElement(null);
        ESExtensionElement noPrio2 = SessionManagerTest.createExtensionElement(1);
        ESExtensionPoint testConfiguration = SessionManagerTest.createExtensionPoint(Arrays.asList(noPrio1, noPrio2));
        ESExtensionElement result = SessionManager.analyseUsersessionExtensionPoint((ESExtensionPoint)testConfiguration);
        Assert.assertSame((Object)noPrio2, (Object)result);
    }

    @Test
    public void testSessionProviderExtensionPointSamePrios() {
        ESExtensionElement noPrio1 = SessionManagerTest.createExtensionElement(1);
        ESExtensionElement noPrio2 = SessionManagerTest.createExtensionElement(1);
        ESExtensionPoint testConfiguration = SessionManagerTest.createExtensionPoint(Arrays.asList(noPrio1, noPrio2));
        ESExtensionElement result = SessionManager.analyseUsersessionExtensionPoint((ESExtensionPoint)testConfiguration);
        Assert.assertSame((Object)noPrio1, (Object)result);
    }

    @Test
    public void testSessionProviderExtensionPointDifferentPrios() {
        ESExtensionElement noPrio1 = SessionManagerTest.createExtensionElement(1);
        ESExtensionElement noPrio2 = SessionManagerTest.createExtensionElement(2);
        ESExtensionPoint testConfiguration = SessionManagerTest.createExtensionPoint(Arrays.asList(noPrio1, noPrio2));
        ESExtensionElement result = SessionManager.analyseUsersessionExtensionPoint((ESExtensionPoint)testConfiguration);
        Assert.assertSame((Object)noPrio2, (Object)result);
    }

    private static ESExtensionPoint createExtensionPoint(final List<ESExtensionElement> elements) {
        return new ESExtensionPoint(""){

            public void reload() {
                this.setElements(elements);
            }
        };
    }

    private static ESExtensionElement createExtensionElement(final Integer integer) {
        return new ESExtensionElement(null){

            public Integer getInteger(String name) {
                return integer;
            }
        };
    }
}

