/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.scm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.FilterOperations;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.FilteredOperationsResult;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.VirtualNode;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.jface.viewers.ITreeContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMContentProvider
extends AdapterFactoryContentProvider
implements ITreeContentProvider {
    private boolean showRootNodes = true;
    private boolean reverseNodes = true;
    private Map<ChangePackage, VirtualNode<AbstractOperation>> changePackageToFilteredMapping = new LinkedHashMap<ChangePackage, VirtualNode<AbstractOperation>>();
    private Map<ChangePackage, List<Object>> changePackageToNonFilteredMapping = new LinkedHashMap<ChangePackage, List<Object>>();
    private ModelElementIdToEObjectMapping idToEObjectMapping;

    public SCMContentProvider() {
        super((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    public SCMContentProvider(ModelElementIdToEObjectMapping idToEObjectMapping) {
        this();
        this.idToEObjectMapping = idToEObjectMapping;
    }

    public void setReverseNodes(boolean reverseNodes) {
        this.reverseNodes = reverseNodes;
    }

    public boolean isReverseNodes() {
        return this.reverseNodes;
    }

    public Object[] getElements(Object object) {
        if (object instanceof List && this.showRootNodes) {
            List list = (List)object;
            ArrayList result = new ArrayList(list.size());
            result.addAll(list);
            return result.toArray();
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return list.toArray();
            }
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            if (this.isListOf(list, HistoryInfo.class)) {
                for (HistoryInfo info : list) {
                    if (info.getChangePackage() == null) continue;
                    result.addAll(this.getReversedOperations(info.getChangePackage()));
                }
            } else if (this.isListOf(list, AbstractOperation.class)) {
                FilteredOperationsResult filteredOpsResult = new FilterOperations(this.idToEObjectMapping).filter(list.toArray());
                result.addAll(filteredOpsResult.getNonFiltered());
                if (filteredOpsResult.getFilteredOperations().size() > 0) {
                    VirtualNode<AbstractOperation> node = new VirtualNode<AbstractOperation>(filteredOpsResult.getFilteredOperations());
                    result.add(node);
                }
            } else {
                for (ChangePackage changePackage : list) {
                    result.addAll(this.getReversedOperations(changePackage));
                }
            }
            return result.toArray();
        }
        if (object instanceof EObject) {
            return new Object[]{object};
        }
        return super.getElements(object);
    }

    private List<AbstractOperation> getReversedOperations(ChangePackage changePackage) {
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>((Collection<AbstractOperation>)changePackage.getOperations());
        Collections.reverse(ops);
        return ops;
    }

    private boolean isListOf(List<?> list, Class<? extends EObject> clazz) {
        Object firstElement = list.get(0);
        return clazz.isInstance(firstElement);
    }

    private void filter(ChangePackage changePackage, Object[] input, Class<? extends EObject> clazz) {
        if (this.changePackageHasBeenFiltered(changePackage)) {
            return;
        }
        FilteredOperationsResult result = new FilterOperations(this.idToEObjectMapping, clazz).filter(input);
        VirtualNode<AbstractOperation> node = new VirtualNode<AbstractOperation>(result.getFilteredOperations());
        this.changePackageToNonFilteredMapping.put(changePackage, result.getNonFiltered());
        this.changePackageToFilteredMapping.put(changePackage, node);
    }

    private boolean changePackageHasBeenFiltered(ChangePackage changePackage) {
        return this.changePackageToNonFilteredMapping.containsKey(changePackage);
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof HistoryInfo) {
            HistoryInfo historyInfo = (HistoryInfo)object;
            return this.getChildren(historyInfo.getChangePackage());
        }
        if (object instanceof ChangePackage) {
            ArrayList<VirtualNode<AbstractOperation>> result = new ArrayList<VirtualNode<AbstractOperation>>();
            ChangePackage changePackage = (ChangePackage)object;
            this.filter(changePackage, super.getChildren(object), LogMessage.class);
            result.addAll((Collection)this.changePackageToNonFilteredMapping.get(changePackage));
            VirtualNode<AbstractOperation> node = this.changePackageToFilteredMapping.get(changePackage);
            if (node.getContent().size() > 0) {
                result.add(node);
            }
            return result.toArray();
        }
        if (object instanceof VirtualNode) {
            return ((VirtualNode)object).getContent().toArray();
        }
        if (object instanceof CompositeOperation) {
            return ((CompositeOperation)object).getSubOperations().toArray();
        }
        return super.getChildren(object);
    }

    public boolean isShowRootNodes() {
        return this.showRootNodes;
    }

    public void setShowRootNodes(boolean showRootNodes) {
        this.showRootNodes = showRootNodes;
    }
}

