/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportController {
    private final AdminBroker adminBroker;
    private ImportSource importSource;
    private final Map<ACOrgUnitId, ImportItemWrapper> importedUnits;

    public ImportController(AdminBroker adminBroker) {
        this.adminBroker = adminBroker;
        this.importedUnits = new HashMap<ACOrgUnitId, ImportItemWrapper>();
    }

    public void importOrgUnits(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        this.importGroups(wrappedOrgUnits);
        this.importUsers(wrappedOrgUnits);
        this.setAssociations();
    }

    private void importUsers(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        int i = 0;
        while (i < wrappedOrgUnits.size()) {
            ImportItemWrapper wrappedOrgUnit = wrappedOrgUnits.get(i);
            if (wrappedOrgUnit.getOrgUnit() instanceof ACUser) {
                try {
                    String username = wrappedOrgUnit.getOrgUnit().getName();
                    if (this.existUser(username) == null) {
                        this.importedUnits.put(this.adminBroker.createUser(username), wrappedOrgUnit);
                    }
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ImportController_Insufficient_Access_Rights, (String)Messages.ImportController_Not_Allowed_To_Create_Users);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
            }
            ++i;
        }
    }

    private void importGroups(ArrayList<ImportItemWrapper> wrappedOrgUnits) {
        int i = 0;
        while (i < wrappedOrgUnits.size()) {
            ImportItemWrapper wrappedOrgUnit = wrappedOrgUnits.get(i);
            if (wrappedOrgUnit.getOrgUnit() instanceof ACGroup) {
                try {
                    String groupname = wrappedOrgUnit.getOrgUnit().getName();
                    if (this.existGroup(groupname) == null) {
                        this.importedUnits.put(this.adminBroker.createGroup(groupname), wrappedOrgUnit);
                    }
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ImportController_Insufficient_Access_Rights, (String)Messages.ImportController_Not_Allowed_To_Create_Groups);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
            }
            ++i;
        }
    }

    private void setAssociations() {
        for (ACOrgUnitId unitId : this.importedUnits.keySet()) {
            ACOrgUnitId existGroup;
            if (this.importedUnits.get(unitId).getParentOrgUnit() == null || (existGroup = this.existGroup(this.importedUnits.get(unitId).getParentOrgUnit().getOrgUnit().getName())) == null || existGroup.equals(unitId)) continue;
            try {
                this.adminBroker.addMember(existGroup, unitId);
            }
            catch (ESException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)((Object)e));
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        }
    }

    private ACOrgUnitId existGroup(String groupName) {
        ACOrgUnitId exist = null;
        try {
            for (ACGroup acGroup : this.getAdminBroker().getGroups()) {
                if (!acGroup.getName().equalsIgnoreCase(groupName)) continue;
                exist = acGroup.getId();
                break;
            }
        }
        catch (AccessControlException accessControlException) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ImportController_Insufficient_Access_Rights, (String)Messages.ImportController_Not_Allowed_To_List_Groups);
        }
        catch (ESException ex) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
        }
        return exist;
    }

    private ACOrgUnitId existUser(String userName) {
        ACOrgUnitId exist = null;
        try {
            for (ACUser acUser : this.getAdminBroker().getUsers()) {
                if (!acUser.getName().equalsIgnoreCase(userName)) continue;
                exist = acUser.getId();
                break;
            }
        }
        catch (AccessControlException accessControlException) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ImportController_Insufficient_Access_Rights, (String)Messages.ImportController_Not_Allowed_To_List_Users);
        }
        catch (ESException ex) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
        }
        return exist;
    }

    public AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    public void setImportSource(ImportSource importSource) {
        this.importSource = importSource;
    }

    public ImportSource getImportSource() {
        return this.importSource;
    }

    public String getTitle() {
        return this.importSource == null ? "" : this.importSource.getLabel();
    }

    public String getMessage() {
        return this.importSource == null ? "" : this.importSource.getMessage();
    }
}

