/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.installer.Messages;
import org.eclipse.equinox.internal.p2.installer.ui.InstallDialog;
import org.eclipse.equinox.internal.provisional.p2.installer.IInstallOperation;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.swt.widgets.Display;

public class SWTInstallAdvisor
extends InstallAdvisor {
    private InstallDialog dialog;
    private boolean started = false;
    private boolean stopped = false;

    public IStatus performInstall(IInstallOperation operation) {
        return this.dialog.run(operation);
    }

    public InstallDescription prepareInstallDescription(InstallDescription description) {
        if (description.getInstallLocation() == null) {
            this.dialog.promptForLocations(description);
        }
        return description;
    }

    public boolean promptForLaunch(InstallDescription description) {
        return this.dialog.promptForLaunch(description);
    }

    public void setResult(IStatus status) {
        String message = status.getSeverity() == 8 ? Messages.Advisor_Canceled : status.getMessage();
        this.dialog.promptForClose(message);
    }

    public synchronized void start() {
        if (this.stopped || this.started) {
            return;
        }
        this.started = true;
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        this.dialog = new InstallDialog();
        this.dialog.setMessage(Messages.Advisor_Preparing);
    }

    public synchronized void stop() {
        if (this.stopped || !this.started) {
            return;
        }
        this.stopped = true;
        final InstallDialog activeDialog = this.dialog;
        if (activeDialog == null) {
            return;
        }
        this.dialog = null;
        Display display = activeDialog.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            public void run() {
                activeDialog.close();
            }
        });
        display.dispose();
    }
}

