/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.client.internal.xmlrpc;

import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.eclipse.equinox.jmx.client.remote.RemoteMBeanConnection;
import org.eclipse.equinox.jmx.client.remote.RemoteNotificationHandler;
import org.eclipse.equinox.jmx.common.NamedNotification;

public class XMLRPCMBeanServerConnection
implements MBeanServerConnection,
RemoteMBeanConnection {
    private static final String CREATE_MBEAN = "createMBean";
    private XmlRpcClient clientConnection;
    private RemoteNotificationHandler notificationHandler;

    public XMLRPCMBeanServerConnection(XmlRpcClient clientConnection) {
        this.clientConnection = clientConnection;
        this.notificationHandler = new RemoteNotificationHandler((RemoteMBeanConnection)this);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return (ObjectInstance)this.clientConnection.execute(CREATE_MBEAN, new Object[]{className, name});
        }
        catch (XmlRpcException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.clientConnection.execute(CREATE_MBEAN, new Object[]{className, name, loaderName});
        }
        catch (XmlRpcException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return (ObjectInstance)this.clientConnection.execute(CREATE_MBEAN, new Object[]{className, name, params, signature});
        }
        catch (XmlRpcException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.clientConnection.execute(CREATE_MBEAN, new Object[]{className, name, loaderName, params, signature});
        }
        catch (XmlRpcException e) {
            throw new MBeanException((Exception)((Object)e));
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.clientConnection.execute("unregisterMBean", new Object[]{name});
        }
        catch (XmlRpcException e) {
            throw new MBeanRegistrationException((Exception)((Object)e));
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.clientConnection.execute("getObjectInstance", new Object[]{name});
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        try {
            return (Set)this.clientConnection.execute("queryMBeans", new Object[]{name, query});
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        try {
            return (Set)this.clientConnection.execute("queryNames", new Object[]{name, query});
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        return false;
    }

    public Integer getMBeanCount() throws IOException {
        return null;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            return this.clientConnection.execute(name + "|" + operationName, params == null ? new Object[]{} : params);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getDefaultDomain() throws IOException {
        return null;
    }

    public String[] getDomains() throws IOException {
        return null;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.notificationHandler.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return null;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        return false;
    }

    public NamedNotification[] retrieveNotifications(long startId) {
        try {
            Object obj = this.clientConnection.execute("retrieveNotifications", new Object[]{new Long(startId)});
            if (obj instanceof Object[]) {
                Object[] objs = (Object[])obj;
                NamedNotification[] result = new NamedNotification[objs.length];
                int i = 0;
                while (i < objs.length) {
                    if (objs[i] instanceof NamedNotification) {
                        result[i] = (NamedNotification)objs[i];
                    }
                    ++i;
                }
                return result;
            }
        }
        catch (XmlRpcException xmlRpcException) {}
        return null;
    }
}

