/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import java.util.Collection;
import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.OutputPosition;
import org.eclipse.escet.chi.codegen.classes.SelectAlternativeClass;
import org.eclipse.escet.chi.codegen.expressions.BehaviorHelper;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.AssignmentConversions;
import org.eclipse.escet.chi.codegen.statements.seq.ForLoopConversion;
import org.eclipse.escet.chi.codegen.statements.seq.SeqBox;
import org.eclipse.escet.chi.codegen.statements.seq.SeqBreak;
import org.eclipse.escet.chi.codegen.statements.seq.SeqCode;
import org.eclipse.escet.chi.codegen.statements.seq.SeqContinue;
import org.eclipse.escet.chi.codegen.statements.seq.SeqExit;
import org.eclipse.escet.chi.codegen.statements.seq.SeqForLoop;
import org.eclipse.escet.chi.codegen.statements.seq.SeqIfElse;
import org.eclipse.escet.chi.codegen.statements.seq.SeqList;
import org.eclipse.escet.chi.codegen.statements.seq.SeqReturn;
import org.eclipse.escet.chi.codegen.statements.seq.SeqSelect;
import org.eclipse.escet.chi.codegen.statements.seq.SeqWhile;
import org.eclipse.escet.chi.codegen.types.StringTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.AssignmentStatement;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.BreakStatement;
import org.eclipse.escet.chi.metamodel.chi.CloseStatement;
import org.eclipse.escet.chi.metamodel.chi.CommunicationStatement;
import org.eclipse.escet.chi.metamodel.chi.ContinueStatement;
import org.eclipse.escet.chi.metamodel.chi.CreateCase;
import org.eclipse.escet.chi.metamodel.chi.DelayStatement;
import org.eclipse.escet.chi.metamodel.chi.ExitStatement;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FinishStatement;
import org.eclipse.escet.chi.metamodel.chi.ForStatement;
import org.eclipse.escet.chi.metamodel.chi.IfCase;
import org.eclipse.escet.chi.metamodel.chi.IfStatement;
import org.eclipse.escet.chi.metamodel.chi.IteratedCreateCase;
import org.eclipse.escet.chi.metamodel.chi.IteratedSelectCase;
import org.eclipse.escet.chi.metamodel.chi.PassStatement;
import org.eclipse.escet.chi.metamodel.chi.ProcessInstance;
import org.eclipse.escet.chi.metamodel.chi.ReceiveStatement;
import org.eclipse.escet.chi.metamodel.chi.ReturnStatement;
import org.eclipse.escet.chi.metamodel.chi.RunStatement;
import org.eclipse.escet.chi.metamodel.chi.SelectCase;
import org.eclipse.escet.chi.metamodel.chi.SelectStatement;
import org.eclipse.escet.chi.metamodel.chi.SendStatement;
import org.eclipse.escet.chi.metamodel.chi.Statement;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.Unwind;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.WhileStatement;
import org.eclipse.escet.chi.metamodel.chi.WriteStatement;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class Seq
extends OutputPosition {
    public Seq(PositionObject chiobj) {
        super(chiobj);
    }

    public abstract Box boxify();

    private static List<Seq> mkSeqs(Seq seq) {
        List seqs = Lists.listc((int)1);
        Assert.notNull((Object)seq);
        seqs.add(seq);
        return seqs;
    }

    private static void initializeVariables(List<VariableDeclaration> vars, VBox codeBox, CodeGeneratorContext ctxt, JavaFile currentClass) {
        for (VariableDeclaration vd : vars) {
            if (vd.isParameter()) continue;
            String name = ctxt.getDefinition((PositionObject)vd);
            if (vd.getInitialValue() != null) {
                ExpressionBase initExpr = ExpressionBase.convertExpression(vd.getInitialValue(), ctxt, currentClass);
                String posStat = initExpr.genCurrentPositionStatement();
                if (posStat != null) {
                    codeBox.add(posStat);
                }
                codeBox.add(initExpr.getCode());
                String line = Strings.fmt((String)"%s = %s;", (Object[])new Object[]{name, initExpr.getValue()});
                codeBox.add(line);
                continue;
            }
            Type tp = TypeIDCreation.dropTypeReferences(vd.getType());
            TypeID tid = TypeIDCreation.createTypeID(tp, ctxt);
            tid.assignInitialValue(name, tp, codeBox, ctxt, currentClass);
        }
    }

    public static List<Seq> convertVarInitialization(BehaviourDeclaration bd, CodeGeneratorContext ctxt, JavaFile currentClass) {
        VBox b = new VBox(0);
        Seq.initializeVariables((List<VariableDeclaration>)bd.getVariables(), b, ctxt, currentClass);
        return Seq.mkSeqs(new SeqBox((Box)b, null));
    }

    public static List<Seq> convertStatements(List<Statement> stats, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List seqs = Lists.list();
        for (Statement stat : stats) {
            List<Seq> result = Seq.convertStatement(stat, ctxt, currentClass);
            for (Seq s : result) {
                Assert.notNull((Object)s);
            }
            seqs.addAll(result);
        }
        return seqs;
    }

    private static List<Seq> convertStatement(Statement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        if (stat instanceof AssignmentStatement) {
            return Seq.convertAsgStatement((AssignmentStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof BreakStatement) {
            BreakStatement bs = (BreakStatement)stat;
            return Seq.mkSeqs(new SeqBreak(bs));
        }
        if (stat instanceof ContinueStatement) {
            ContinueStatement cs = (ContinueStatement)stat;
            return Seq.mkSeqs(new SeqContinue(cs));
        }
        if (stat instanceof DelayStatement) {
            return Seq.convertDelayStatement((DelayStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof ForStatement) {
            return Seq.convertForStatement((ForStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof IfStatement) {
            return Seq.convertIfStatement((IfStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof PassStatement) {
            return Seq.mkSeqs(new SeqCode(null, (PositionObject)stat));
        }
        if (stat instanceof ReceiveStatement) {
            return Seq.convertReceiveStatement((ReceiveStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof ReturnStatement) {
            return Seq.convertReturnStatement((ReturnStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof RunStatement) {
            return Seq.convertRunStatement((RunStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof SelectStatement) {
            return Seq.convertSelectStatement((SelectStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof SendStatement) {
            return Seq.convertSendStatement((SendStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof ExitStatement) {
            return Seq.convertExitStatement((ExitStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof WhileStatement) {
            return Seq.convertWhileStatement((WhileStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof WriteStatement) {
            return Seq.convertWriteStatement((WriteStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof CloseStatement) {
            return Seq.convertCloseStatement((CloseStatement)stat, ctxt, currentClass);
        }
        if (stat instanceof FinishStatement) {
            return Seq.convertFinishStatement((FinishStatement)stat, ctxt, currentClass);
        }
        Assert.fail((Object)"Unknown Chi statement encountered.");
        return null;
    }

    private static List<Seq> convertAsgStatement(AssignmentStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        SeqCode code = AssignmentConversions.convertAssignment(stat, ctxt, currentClass);
        return Seq.mkSeqs(code);
    }

    private static List<Seq> convertDelayStatement(DelayStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase lengthExpr = ExpressionBase.convertExpression(stat.getLength(), ctxt, currentClass);
        SeqCode code = new SeqCode(null, (PositionObject)stat);
        code.genCurrentPositionStatement();
        code.lines.addAll(lengthExpr.getCode());
        code.lines.add(Strings.fmt((String)"setDelayTimer(%s);", (Object[])new Object[]{lengthExpr.getValue()}));
        int delayAlternativeNumber = ctxt.getUniqueDeclNumber();
        String s = Strings.fmt((String)"selectList.add(new SelectDelay(chiCoordinator, this, %d));", (Object[])new Object[]{delayAlternativeNumber});
        currentClass.addImport("org.eclipse.escet.chi.runtime.SelectDelay", false);
        code.lines.add(s);
        SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(delayAlternativeNumber, Seq.mkSeqs(code), null, null);
        return Seq.mkSeqs(new SeqSelect(Lists.list((Object)sa), (PositionObject)stat));
    }

    private static List<Seq> convertForStatement(ForStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ForLoopConversion.ForLoopSeqResult flsr = ForLoopConversion.convertForLoop((PositionObject)stat, ctxt, currentClass);
        List seqs = Lists.list();
        if (flsr.varInit != null) {
            seqs.add(flsr.varInit);
        }
        seqs.addAll(Seq.convertStatements((List<Statement>)stat.getBody(), ctxt, currentClass));
        return Seq.mkSeqs(new SeqForLoop(flsr.loopInit, flsr.loopCond, flsr.loopIncr, new SeqList(seqs), (PositionObject)stat));
    }

    private static List<Seq> convertIfStatement(IfStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List prevCase = null;
        int idx = stat.getCases().size() - 1;
        while (idx >= 0) {
            IfCase ifc = (IfCase)stat.getCases().get(idx);
            if (ifc.getCondition() == null) {
                prevCase = Seq.convertStatements((List<Statement>)ifc.getBody(), ctxt, currentClass);
            } else {
                ExpressionBase cond = ExpressionBase.convertExpression(ifc.getCondition(), ctxt, currentClass);
                List<Seq> ifsr = Seq.convertStatements((List<Statement>)ifc.getBody(), ctxt, currentClass);
                SeqList ifBranch = new SeqList(ifsr);
                SeqList elseBranch = new SeqList(prevCase);
                SeqIfElse ifElse = new SeqIfElse(cond, ifBranch, elseBranch, ifc);
                prevCase = Lists.list((Object)ifElse);
            }
            --idx;
        }
        Assert.notNull(prevCase);
        return prevCase;
    }

    private static List<Seq> convertReceiveStatement(ReceiveStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        int selChoiceNumber = ctxt.getUniqueDeclNumber();
        String selClassName = SelectAlternativeClass.createSelectCaseClass(selChoiceNumber, null, "GuardKind.TRUE", null, "ChannelKind.RECEIVE", (CommunicationStatement)stat, ctxt, currentClass);
        ExpressionBase ch = ExpressionBase.convertExpression(stat.getChannel(), ctxt, currentClass);
        SeqCode code = new SeqCode(Lists.copy(ch.getCode()), (PositionObject)stat);
        String line = Strings.fmt((String)"selectList.add(new %s(chiCoordinator, %s, spec, this));", (Object[])new Object[]{selClassName, ch.getValue()});
        code.lines.add(line);
        SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(selChoiceNumber, Seq.mkSeqs(code), null, null);
        SeqSelect result = new SeqSelect(Lists.list((Object)sa), (PositionObject)stat);
        return Lists.list((Object)result);
    }

    private static List<Seq> convertReturnStatement(ReturnStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase expr = ExpressionBase.convertExpression(stat.getValue(), ctxt, currentClass);
        TypeID tid = TypeIDCreation.createTypeID(stat.getValue().getType(), ctxt);
        String res = ctxt.makeUniqueName("res");
        List lines = Lists.list();
        lines.addAll(expr.getCode());
        lines.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tid.getJavaType(), res, expr.getValue()}));
        expr = new CodeExpression(lines, res, (PositionObject)stat);
        return Seq.mkSeqs(SeqReturn.funcReturn(expr, stat));
    }

    private static List<Seq> convertCreateProcessInstance(ProcessInstance cc, boolean startOnly, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase expr = ExpressionBase.convertExpression(cc.getCall(), ctxt, currentClass);
        List lines = Lists.list();
        expr.setCurrentPositionStatement(lines);
        lines.addAll(expr.getCode());
        String procVar = ctxt.makeUniqueName("proc");
        lines.add(Strings.fmt((String)"BaseProcess %s = %s;", (Object[])new Object[]{procVar, expr.getValue()}));
        lines.add(Strings.fmt((String)"chiCoordinator.addProcess(%s);", (Object[])new Object[]{procVar}));
        if (!startOnly) {
            Assert.check((cc.getVar() == null ? 1 : 0) != 0);
            lines.add(Strings.fmt((String)"chiChilds.add(%s);", (Object[])new Object[]{procVar}));
        } else if (cc.getVar() != null) {
            ExpressionBase asgVar = ExpressionBase.convertExpression(cc.getVar(), ctxt, currentClass);
            lines.addAll(asgVar.getCode());
            lines.add(Strings.fmt((String)"%s = %s;", (Object[])new Object[]{asgVar.getValue(), procVar}));
        }
        SeqCode seq = new SeqCode(lines, (PositionObject)cc);
        return Lists.list((Object)seq);
    }

    private static List<Seq> convertIteratedCreateCase(IteratedCreateCase icc, boolean startOnly, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List result = Lists.list();
        for (CreateCase cc : icc.getInstances()) {
            List<Seq> instCode = Seq.convertCreateCase(cc, startOnly, ctxt, currentClass);
            result.addAll(instCode);
        }
        int idx = icc.getUnwinds().size() - 1;
        while (idx >= 0) {
            for (Unwind unw : icc.getUnwinds()) {
                ForLoopConversion.ForLoopSeqResult flsr = ForLoopConversion.convertForLoop((PositionObject)unw, ctxt, currentClass);
                List body = Lists.list();
                if (flsr.varInit != null) {
                    body.add(flsr.varInit);
                }
                Assert.notNull((Object)result);
                body.addAll(result);
                SeqForLoop forloop = new SeqForLoop(flsr.loopInit, flsr.loopCond, flsr.loopIncr, new SeqList(body), (PositionObject)unw);
                result = Lists.list((Object)forloop);
            }
            --idx;
        }
        return result;
    }

    private static List<Seq> convertCreateCase(CreateCase cc, boolean startOnly, CodeGeneratorContext ctxt, JavaFile currentClass) {
        if (cc instanceof ProcessInstance) {
            return Seq.convertCreateProcessInstance((ProcessInstance)cc, startOnly, ctxt, currentClass);
        }
        return Seq.convertIteratedCreateCase((IteratedCreateCase)cc, startOnly, ctxt, currentClass);
    }

    private static List<Seq> generateWaitChilds(PositionObject stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        SeqCode code = new SeqCode(null, stat);
        int choice = ctxt.getUniqueDeclNumber();
        String s = "selectList.add(new SelectWaitRunChilds(chiCoordinator, this, " + String.valueOf(choice) + "));";
        code.lines.add(s);
        currentClass.addImport("org.eclipse.escet.chi.runtime.SelectWaitRunChilds", false);
        SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(choice, Seq.mkSeqs(code), null, null);
        SeqSelect result = new SeqSelect(Lists.list((Object)sa), stat);
        return Lists.list((Object)result);
    }

    private static List<Seq> convertRunStatement(RunStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List seqs = Lists.list();
        if (!stat.isStartOnly()) {
            SeqCode code = new SeqCode(null, (PositionObject)stat);
            code.lines.add("clearChildProcesses();");
            seqs.add(code);
        }
        for (CreateCase cc : stat.getCases()) {
            List<Seq> caseCode = Seq.convertCreateCase(cc, stat.isStartOnly(), ctxt, currentClass);
            seqs.addAll(caseCode);
        }
        if (!stat.isStartOnly()) {
            List<Seq> waitCode = Seq.generateWaitChilds((PositionObject)stat, ctxt, currentClass);
            seqs.addAll(waitCode);
        }
        return seqs;
    }

    private static BehaviorHelper.ExprBehavior getGuardBehavior(Expression guard) {
        if (guard == null) {
            return BehaviorHelper.ExprBehavior.CONSTANT;
        }
        return BehaviorHelper.getBehavior(guard);
    }

    private static List<Seq> addSingleSelect(int selChoiceNumber, List<VariableDeclaration> localVars, SelectCase sc, CodeGeneratorContext ctxt, JavaFile currentClass) {
        String line;
        boolean hasCondition;
        String channelKind;
        CommunicationStatement commStat;
        Expression guardExpr;
        String guardKind;
        switch (Seq.getGuardBehavior(sc.getGuard())) {
            case CONSTANT: 
            case DISCRETE: {
                guardKind = "GuardKind.TRUE";
                guardExpr = null;
                break;
            }
            case TIME: {
                guardKind = "GuardKind.FUNC";
                guardExpr = sc.getGuard();
                break;
            }
            default: {
                Assert.fail((Object)"Invalid kind of guard.");
                return null;
            }
        }
        Statement stat = (Statement)sc.getBody().get(0);
        if (stat == null) {
            commStat = null;
            channelKind = "ChannelKind.NONE";
        } else if (stat instanceof SendStatement) {
            commStat = (CommunicationStatement)stat;
            channelKind = "ChannelKind.SEND";
        } else if (stat instanceof ReceiveStatement) {
            commStat = (CommunicationStatement)stat;
            channelKind = "ChannelKind.RECEIVE";
        } else {
            Assert.check((boolean)(stat instanceof PassStatement));
            commStat = null;
            channelKind = "ChannelKind.NONE";
        }
        String selClassName = SelectAlternativeClass.createSelectCaseClass(selChoiceNumber, localVars, guardKind, guardExpr, channelKind, commStat, ctxt, currentClass);
        SeqCode code = new SeqCode(null, (PositionObject)sc);
        Object vars = "";
        if (localVars != null) {
            for (VariableDeclaration vd : localVars) {
                String name = ctxt.getDefinition((PositionObject)vd);
                vars = (String)vars + ", " + name;
            }
        }
        boolean bl = hasCondition = guardExpr == null && sc.getGuard() != null;
        if (hasCondition) {
            ExpressionBase ge = ExpressionBase.convertExpression(sc.getGuard(), ctxt, currentClass);
            code.lines.addAll(ge.getCode());
            code.lines.add("if (" + ge.getValue() + ") {");
        }
        if (commStat == null) {
            line = "null";
        } else {
            ExpressionBase ch = ExpressionBase.convertExpression(commStat.getChannel(), ctxt, currentClass);
            ch.setCurrentPositionStatement(code.lines);
            code.lines.addAll(ch.getCode());
            line = ch.getValue();
        }
        line = Strings.fmt((String)"selectList.add(new %s(chiCoordinator, %s, spec, this%s));", (Object[])new Object[]{selClassName, line, vars});
        code.lines.add(line);
        if (hasCondition) {
            code.lines.add("}");
        }
        List seqs = Lists.listc((int)1);
        seqs.add(code);
        return seqs;
    }

    private static List<Seq> addIteratedSelect(int selChoiceNumber, IteratedSelectCase sc, List<VariableDeclaration> localVars, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List<Seq> result = null;
        int idx = sc.getUnwinds().size();
        while (idx >= 0) {
            if (idx == sc.getUnwinds().size()) {
                result = Seq.addSingleSelect(selChoiceNumber, localVars, (SelectCase)sc, ctxt, currentClass);
            } else {
                Unwind unw = (Unwind)sc.getUnwinds().get(idx);
                ForLoopConversion.ForLoopSeqResult flsr = ForLoopConversion.convertForLoop((PositionObject)unw, ctxt, currentClass);
                List seqs = Lists.list();
                if (flsr.varInit != null) {
                    seqs.add(flsr.varInit);
                }
                seqs.addAll(result);
                SeqForLoop sfl = new SeqForLoop(flsr.loopInit, flsr.loopCond, flsr.loopIncr, new SeqList(seqs), (PositionObject)unw);
                result = Seq.mkSeqs(sfl);
            }
            --idx;
        }
        Assert.notNull(result);
        return result;
    }

    private static List<Seq> convertSelectStatement(SelectStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List alternatives = Lists.listc((int)stat.getCases().size());
        for (SelectCase sc : stat.getCases()) {
            int selChoiceNumber = ctxt.getUniqueDeclNumber();
            if (sc instanceof IteratedSelectCase) {
                IteratedSelectCase isc = (IteratedSelectCase)sc;
                List localVars = Lists.list();
                for (Unwind unw : isc.getUnwinds()) {
                    localVars.addAll(unw.getVariables());
                }
                List<Seq> sr = Seq.addIteratedSelect(selChoiceNumber, isc, localVars, ctxt, currentClass);
                Object stats = sc.getBody();
                stats = stats.subList(1, stats.size());
                List<Seq> body = Seq.convertStatements((List<Statement>)stats, ctxt, currentClass);
                SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(selChoiceNumber, sr, new SeqList(body), localVars);
                alternatives.add(sa);
                continue;
            }
            List<Seq> sr = Seq.addSingleSelect(selChoiceNumber, null, sc, ctxt, currentClass);
            Object stats = sc.getBody();
            stats = stats.subList(1, stats.size());
            List<Seq> body = Seq.convertStatements((List<Statement>)stats, ctxt, currentClass);
            SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(selChoiceNumber, sr, new SeqList(body), null);
            alternatives.add(sa);
        }
        SeqSelect result = new SeqSelect(alternatives, (PositionObject)stat);
        return Lists.list((Object)result);
    }

    private static List<Seq> convertSendStatement(SendStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        int selChoiceNumber = ctxt.getUniqueDeclNumber();
        String selClassName = SelectAlternativeClass.createSelectCaseClass(selChoiceNumber, null, "GuardKind.TRUE", null, "ChannelKind.SEND", (CommunicationStatement)stat, ctxt, currentClass);
        ExpressionBase ch = ExpressionBase.convertExpression(stat.getChannel(), ctxt, currentClass);
        SeqCode code = new SeqCode(Lists.copy(ch.getCode()), (PositionObject)stat);
        String line = Strings.fmt((String)"selectList.add(new %s(chiCoordinator, %s, spec, this));", (Object[])new Object[]{selClassName, ch.getValue()});
        code.lines.add(line);
        SeqSelect.SelectAlternative sa = new SeqSelect.SelectAlternative(selChoiceNumber, Seq.mkSeqs(code), null, null);
        SeqSelect result = new SeqSelect(Lists.list((Object)sa), (PositionObject)stat);
        return Lists.list((Object)result);
    }

    private static List<Seq> convertExitStatement(ExitStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase exitVal = null;
        if (stat.getValue() != null) {
            exitVal = ExpressionBase.convertExpression(stat.getValue(), ctxt, currentClass);
        }
        return Seq.mkSeqs(new SeqExit(exitVal, stat));
    }

    private static List<Seq> convertWhileStatement(WhileStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List<Seq> srBody = Seq.convertStatements((List<Statement>)stat.getBody(), ctxt, currentClass);
        SeqList body = new SeqList(srBody);
        ExpressionBase cond = ExpressionBase.convertExpression(stat.getCondition(), ctxt, currentClass);
        return Seq.mkSeqs(new SeqWhile(cond, body, stat));
    }

    private static List<Seq> convertCloseStatement(CloseStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase handle = ExpressionBase.convertExpression(stat.getHandle(), ctxt, currentClass);
        SeqCode code = new SeqCode(null, (PositionObject)stat);
        handle.setCurrentPositionStatement(code.lines);
        code.lines.addAll(handle.getCode());
        code.lines.add(Strings.fmt((String)"chiCoordinator.closeFile(%s);", (Object[])new Object[]{handle.getValue()}));
        return Lists.list((Object)code);
    }

    private static List<Seq> convertFinishStatement(FinishStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List seqs = Lists.list();
        SeqCode code = new SeqCode(null, (PositionObject)stat);
        code.lines.add("clearChildProcesses();");
        seqs.add(code);
        for (Expression inst : stat.getInstances()) {
            ExpressionBase expr = ExpressionBase.convertExpression(inst, ctxt, currentClass);
            code = new SeqCode(null, (PositionObject)inst);
            expr.setCurrentPositionStatement(code.lines);
            code.lines.addAll(expr.getCode());
            String line = Strings.fmt((String)"chiChilds.add(%s);", (Object[])new Object[]{expr.getValue()});
            code.lines.add(line);
            seqs.add(code);
        }
        seqs.addAll(Seq.generateWaitChilds((PositionObject)stat, ctxt, currentClass));
        return seqs;
    }

    private static List<Seq> convertWriteStatement(WriteStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        SeqCode code = new SeqCode(null, (PositionObject)stat);
        int valueIdx = 0;
        String handle = "chiCoordinator.getStdout()";
        Expression expr0 = (Expression)stat.getValues().get(valueIdx);
        Type tp = CheckType.dropReferences((Type)expr0.getType());
        if (tp instanceof FileType) {
            ExpressionBase fexpr = ExpressionBase.convertExpression(expr0, ctxt, currentClass);
            fexpr.setCurrentPositionStatement(code.lines);
            fexpr.setCurrentPositionStatement(code.lines);
            code.lines.addAll(fexpr.getCode());
            handle = fexpr.getValue();
            ++valueIdx;
        }
        StringLiteral fmtExpr = (StringLiteral)stat.getValues().get(valueIdx);
        String fmtPattern = fmtExpr.getValue();
        int offset = ++valueIdx;
        int implicitIdx = 0;
        List writeStatements = Lists.list();
        FormatDecoder decoder = new FormatDecoder();
        for (FormatDescription fd : decoder.decode(fmtPattern)) {
            TypeID tid;
            String line;
            if (fd.conversion == FormatDescription.Conversion.LITERAL) {
                line = Strings.stringToJava((String)fd.toString());
                tid = TypeIDCreation.makeStringTypeID();
            } else {
                valueIdx = offset;
                if (fd.index.isEmpty()) {
                    valueIdx += implicitIdx;
                    ++implicitIdx;
                } else {
                    valueIdx += fd.getExplicitIndex() - 1;
                }
                Expression expr = (Expression)stat.getValues().get(valueIdx);
                ExpressionBase vexpr = ExpressionBase.convertExpression(expr, ctxt, currentClass);
                vexpr.setCurrentPositionStatement(code.lines);
                code.lines.addAll(vexpr.getCode());
                tid = TypeIDCreation.createTypeID(expr.getType(), ctxt);
                line = vexpr.getValue();
                if (!fd.isSimple()) {
                    String dest = ctxt.makeUniqueName("val");
                    line = Strings.fmt((String)"%s %s = %s;\n", (Object[])new Object[]{tid.getJavaType(), dest, line});
                    code.lines.add(line);
                    line = fd.conversion == FormatDescription.Conversion.STRING ? Strings.fmt((String)"fmt(\"%s\", %s)", (Object[])new Object[]{fd.toString(false), tid.getToString(dest, currentClass)}) : Strings.fmt((String)"fmt(\"%s\", %s)", (Object[])new Object[]{fd.toString(false), dest});
                    tid = TypeIDCreation.makeStringTypeID();
                    currentClass.addImport("org.eclipse.escet.common.java.Strings.fmt", true);
                }
            }
            String posStat = Seq.genCurrentPositionStatement((PositionObject)stat);
            if (posStat != null) {
                writeStatements.add(posStat);
            }
            writeStatements.add(tid.getWriteName(handle, line, currentClass));
        }
        code.lines.addAll(writeStatements);
        if (stat.isAddNewline()) {
            StringTypeID tid = TypeIDCreation.makeStringTypeID();
            code.lines.add(((TypeID)tid).getWriteName(handle, "\"\\n\"", currentClass));
        }
        return Seq.mkSeqs(code);
    }

    private static void addRunUnwindVariables(List<CreateCase> cases, List<PositionObject> vars) {
        for (CreateCase cCase : cases) {
            if (!(cCase instanceof IteratedCreateCase)) continue;
            IteratedCreateCase iterCase = (IteratedCreateCase)cCase;
            for (Unwind unw : iterCase.getUnwinds()) {
                vars.add((PositionObject)unw);
                vars.addAll((Collection<PositionObject>)unw.getVariables());
            }
            Seq.addRunUnwindVariables((List<CreateCase>)iterCase.getInstances(), vars);
        }
    }

    public static List<PositionObject> getIteratorVariables(List<Statement> body) {
        List vars = Lists.list();
        for (Statement stat : body) {
            if (stat instanceof ForStatement) {
                ForStatement forStat = (ForStatement)stat;
                vars.add(forStat);
                for (Unwind unw : forStat.getUnwinds()) {
                    vars.add(unw);
                    vars.addAll(unw.getVariables());
                }
                vars.addAll(Seq.getIteratorVariables((List<Statement>)forStat.getBody()));
                continue;
            }
            if (stat instanceof RunStatement) {
                RunStatement runStat = (RunStatement)stat;
                Seq.addRunUnwindVariables((List<CreateCase>)runStat.getCases(), vars);
                continue;
            }
            if (stat instanceof SelectStatement) {
                SelectStatement selStat = (SelectStatement)stat;
                for (SelectCase selCase : selStat.getCases()) {
                    vars.addAll(Seq.getIteratorVariables((List<Statement>)selCase.getBody()));
                    if (!(selCase instanceof IteratedSelectCase)) continue;
                    IteratedSelectCase iterSel = (IteratedSelectCase)selCase;
                    for (Unwind unw : iterSel.getUnwinds()) {
                        vars.add(unw);
                        vars.addAll(unw.getVariables());
                    }
                }
                continue;
            }
            if (stat instanceof WhileStatement) {
                WhileStatement wStat = (WhileStatement)stat;
                vars.addAll(Seq.getIteratorVariables((List<Statement>)wStat.getBody()));
                continue;
            }
            if (!(stat instanceof IfStatement)) continue;
            IfStatement ifs = (IfStatement)stat;
            for (IfCase ifc : ifs.getCases()) {
                vars.addAll(Seq.getIteratorVariables((List<Statement>)ifc.getBody()));
            }
        }
        return vars;
    }
}

