/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.p1cycles.GreedyCycleBreaker;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCycleProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    private final HashMap<LEdge, LEdge> dummyEdgeMap = new HashMap();

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Revert edges to remove cyclic dependencies between compound nodes", 1.0f);
        LGraph cycleRemovalGraph = new LGraph(layeredGraph);
        cycleRemovalGraph.setProperty(Properties.RANDOM, layeredGraph.getProperty(Properties.RANDOM));
        List<LNode> cycleRemovalNodes = cycleRemovalGraph.getLayerlessNodes();
        HashMap<LNode, LNode> insertedNodes = new HashMap<LNode, LNode>();
        LinkedList<LEdge> toDescendantEdges = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            for (LEdge edge : lnode.getOutgoingEdges()) {
                int depthTarget;
                List<LEdge> portIncomingEdges;
                LNode targetNode;
                EdgeType edgeType = (EdgeType)((Object)edge.getProperty(Properties.EDGE_TYPE));
                if (edgeType != EdgeType.NORMAL) continue;
                boolean isDescendantEdge = false;
                LNode sourceNode = edge.getSource().getNode();
                if (Util.isDescendant(sourceNode, targetNode = edge.getTarget().getNode()) || Util.isDescendant(targetNode, sourceNode)) {
                    isDescendantEdge = true;
                }
                LGraphElement sourceParent = Util.getParent(sourceNode);
                LGraphElement targetParent = Util.getParent(targetNode);
                LNode currentSource = sourceNode;
                LNode currentTarget = targetNode;
                LGraphElement currentSourceAncestor = sourceParent;
                LGraphElement currentTargetAncestor = targetParent;
                NodeType sourceNType = (NodeType)((Object)sourceNode.getProperty(Properties.NODE_TYPE));
                if ((sourceNType == NodeType.LOWER_COMPOUND_PORT || sourceNType == NodeType.UPPER_COMPOUND_PORT) && Util.isDescendant(targetNode, (LNode)sourceNode.getProperty(Properties.COMPOUND_NODE)) && !(portIncomingEdges = edge.getSource().getIncomingEdges()).isEmpty()) {
                    boolean descendantIncoming = false;
                    for (LEdge ledge : portIncomingEdges) {
                        if (Util.isDescendant(ledge.getSource().getNode(), (LNode)ledge.getTarget().getNode().getProperty(Properties.COMPOUND_NODE))) {
                            descendantIncoming = true;
                        }
                        if (!descendantIncoming) continue;
                        toDescendantEdges.add(edge);
                    }
                }
                LinkedList<LNode> sourceChildren = Util.getChildren(sourceNode);
                LinkedList<LNode> targetChildren = Util.getChildren(targetNode);
                if (!(currentSourceAncestor != currentTargetAncestor || !Util.getChildren(sourceNode).isEmpty() && !Util.getChildren(targetNode).isEmpty() || sourceChildren.isEmpty() && !targetChildren.isEmpty()) && (sourceChildren.isEmpty() || !targetChildren.isEmpty())) continue;
                int depthSource = (Integer)sourceNode.getProperty(Properties.DEPTH);
                if (depthSource != (depthTarget = ((Integer)targetNode.getProperty(Properties.DEPTH)).intValue())) {
                    int i = depthSource;
                    while (i > depthTarget) {
                        LGraphElement sourceNextParent = Util.getParent(currentSource);
                        assert (sourceNextParent instanceof LNode);
                        currentSource = (LNode)sourceNextParent;
                        --i;
                    }
                    int j = depthTarget;
                    while (j > depthSource) {
                        LGraphElement targetNextParent = Util.getParent(currentTarget);
                        assert (targetNextParent instanceof LNode);
                        currentTarget = (LNode)targetNextParent;
                        --j;
                    }
                }
                if (currentSource == currentTarget) continue;
                currentSourceAncestor = Util.getParent(currentSource);
                currentTargetAncestor = Util.getParent(currentTarget);
                while (currentSourceAncestor != currentTargetAncestor) {
                    assert (currentSourceAncestor instanceof LNode);
                    assert (currentTargetAncestor instanceof LNode);
                    currentSource = (LNode)currentSourceAncestor;
                    currentTarget = (LNode)currentTargetAncestor;
                    currentSourceAncestor = Util.getParent(currentSource);
                    currentTargetAncestor = Util.getParent(currentTarget);
                }
                NodeType sourceNodeType = (NodeType)((Object)currentSource.getProperty(Properties.NODE_TYPE));
                NodeType targetNodeType = (NodeType)((Object)currentTarget.getProperty(Properties.NODE_TYPE));
                if (sourceNodeType != NodeType.NORMAL && sourceNodeType != NodeType.UPPER_COMPOUND_BORDER) {
                    currentSource = (LNode)currentSource.getProperty(Properties.COMPOUND_NODE);
                }
                if (targetNodeType != NodeType.NORMAL && targetNodeType != NodeType.UPPER_COMPOUND_BORDER) {
                    currentTarget = (LNode)currentTarget.getProperty(Properties.COMPOUND_NODE);
                }
                this.insertCycleNode(layeredGraph, currentSource, insertedNodes, cycleRemovalNodes);
                this.insertCycleNode(layeredGraph, currentTarget, insertedNodes, cycleRemovalNodes);
                if (!isDescendantEdge) {
                    NodeType nodeTypeDummySource = (NodeType)((Object)currentSource.getProperty(Properties.NODE_TYPE));
                    if (nodeTypeDummySource == NodeType.NORMAL) {
                        this.insertDummyEdge(layeredGraph, currentTarget, currentSource, edge);
                    } else {
                        for (LNode node : layeredGraph.getLayerlessNodes()) {
                            if (node.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_BORDER && node.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_PORT || node.getProperty(Properties.COMPOUND_NODE) != currentSource) continue;
                            this.insertDummyEdge(layeredGraph, currentTarget, node, edge);
                        }
                    }
                }
                LEdge cycleGraphEdge = new LEdge(layeredGraph);
                cycleGraphEdge.setProperty(Properties.ORIGIN, edge);
                LPort cycleSourcePort = new LPort(layeredGraph);
                LPort cycleTargetPort = new LPort(layeredGraph);
                cycleGraphEdge.setSource(cycleSourcePort);
                cycleGraphEdge.setTarget(cycleTargetPort);
                cycleSourcePort.setNode(insertedNodes.get(currentSource));
                cycleTargetPort.setNode(insertedNodes.get(currentTarget));
            }
        }
        this.reverseCyclicEdges(layeredGraph, cycleRemovalGraph);
        int toDescendantSize = toDescendantEdges.size();
        int i = 0;
        while (i < toDescendantSize) {
            LEdge edge;
            edge = (LEdge)toDescendantEdges.get(i);
            if (!((Boolean)edge.getProperty(Properties.REVERSED)).booleanValue()) {
                edge.reverse(layeredGraph, true);
            }
            ++i;
        }
        this.getMonitor().done();
    }

    private void insertDummyEdge(LGraph layeredGraph, LNode target, LNode source, LEdge edge) {
        LEdge dummyEdge = new LEdge(layeredGraph);
        this.dummyEdgeMap.put(edge, dummyEdge);
        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
        LPort dummyPortSource = new LPort(layeredGraph);
        LPort dummyPortTarget = new LPort(layeredGraph);
        dummyEdge.setSource(dummyPortSource);
        dummyEdge.setTarget(dummyPortTarget);
        dummyPortTarget.setNode(target);
        dummyPortSource.setNode(source);
    }

    private void insertCycleNode(LGraph layeredGraph, LNode node, HashMap<LNode, LNode> insertedNodes, List<LNode> cycleRemovalNodes) {
        if (!insertedNodes.containsKey(node)) {
            LNode cycleGraphNode = new LNode(layeredGraph);
            cycleGraphNode.setProperty(Properties.ORIGIN, node);
            insertedNodes.put(node, cycleGraphNode);
            cycleRemovalNodes.add(cycleGraphNode);
        }
    }

    private void reverseCyclicEdges(LGraph layeredGraph, LGraph cycleRemovalGraph) {
        LinkedList<LEdge> edgesToReverse = new LinkedList<LEdge>();
        GreedyCycleBreaker cycleBreaker = new GreedyCycleBreaker();
        cycleBreaker.process(cycleRemovalGraph);
        for (LNode lnode : cycleRemovalGraph.getLayerlessNodes()) {
            for (LEdge ledge : lnode.getOutgoingEdges()) {
                if (!((Boolean)ledge.getProperty(Properties.REVERSED)).booleanValue()) continue;
                edgesToReverse.add((LEdge)ledge.getProperty(Properties.ORIGIN));
            }
        }
        this.reverseEdges(edgesToReverse, layeredGraph);
    }

    private void reverseEdges(LinkedList<LEdge> edgeList, LGraph layeredGraph) {
        int i = 0;
        while (i < edgeList.size()) {
            LEdge dummyEdge;
            LEdge edge = edgeList.get(i);
            LPort source = edge.getSource();
            LPort target = edge.getTarget();
            LNode sourceNode = source.getNode();
            LNode targetNode = target.getNode();
            NodeType sourceNodeType = (NodeType)((Object)sourceNode.getProperty(Properties.NODE_TYPE));
            NodeType targetNodeType = (NodeType)((Object)targetNode.getProperty(Properties.NODE_TYPE));
            LPort newSource = edge.getTarget();
            LPort newTarget = edge.getSource();
            if (targetNodeType != NodeType.NORMAL) {
                newSource = this.getOppositePort(target, layeredGraph);
            }
            if (sourceNodeType != NodeType.NORMAL) {
                newTarget = this.getOppositePort(source, layeredGraph);
            }
            edge.setSource(newSource);
            edge.setTarget(newTarget);
            edge.setProperty(Properties.REVERSED, true);
            LinkedList<LEdge> removableEdges = new LinkedList<LEdge>();
            if (sourceNodeType == NodeType.LOWER_COMPOUND_PORT) {
                for (LEdge ledge : sourceNode.getConnectedEdges()) {
                    removableEdges.add(ledge);
                }
                for (LEdge ledge : removableEdges) {
                    ledge.getTarget().getIncomingEdges().remove(ledge);
                    ledge.getSource().getOutgoingEdges().remove(ledge);
                }
                layeredGraph.getLayerlessNodes().remove(sourceNode);
            }
            if (targetNodeType == NodeType.UPPER_COMPOUND_PORT) {
                for (LEdge ledge : targetNode.getConnectedEdges()) {
                    removableEdges.add(ledge);
                }
                for (LEdge ledge : removableEdges) {
                    ledge.getTarget().getIncomingEdges().remove(ledge);
                    ledge.getSource().getOutgoingEdges().remove(ledge);
                }
                layeredGraph.getLayerlessNodes().remove(targetNode);
            }
            if ((dummyEdge = this.dummyEdgeMap.get(edge)) != null) {
                dummyEdge.getSource().getOutgoingEdges().remove(dummyEdge);
                dummyEdge.getTarget().getIncomingEdges().remove(dummyEdge);
            }
            ++i;
        }
    }

    private LPort getOppositePort(LPort port, LGraph layeredGraph) {
        float edgeSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue() * ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        PortSide portSide = port.getSide();
        PortSide newSide = portSide == PortSide.EAST ? PortSide.WEST : PortSide.EAST;
        LPort newPort = new LPort(layeredGraph);
        newPort.getSize().x = port.getSize().x;
        newPort.getSize().y = port.getSize().y;
        newPort.copyProperties((IPropertyHolder)port);
        newPort.setSide(newSide);
        LNode node = port.getNode();
        NodeType nodeType = (NodeType)((Object)node.getProperty(Properties.NODE_TYPE));
        switch (nodeType) {
            case UPPER_COMPOUND_BORDER: {
                LShape lowerBorder = null;
                for (LNode lnode : layeredGraph.getLayerlessNodes()) {
                    if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.LOWER_COMPOUND_BORDER || lnode.getProperty(Properties.COMPOUND_NODE) != node) continue;
                    lowerBorder = lnode;
                    break;
                }
                newPort.setNode((LNode)lowerBorder);
                lowerBorder.getSize().y += (double)edgeSpacing;
                break;
            }
            case UPPER_COMPOUND_PORT: {
                LNode newLowerCompoundPort = new LNode(layeredGraph);
                newLowerCompoundPort.copyProperties((IPropertyHolder)node);
                newLowerCompoundPort.setProperty(Properties.NODE_TYPE, (Object)NodeType.LOWER_COMPOUND_PORT);
                newLowerCompoundPort.setProperty(Properties.COMPOUND_NODE, node.getProperty(Properties.COMPOUND_NODE));
                LPort dummyConnectionPort = new LPort(layeredGraph);
                dummyConnectionPort.setSide(PortSide.WEST);
                dummyConnectionPort.setNode(newLowerCompoundPort);
                for (LNode child : Util.getChildren(node)) {
                    LEdge dummyEdge = new LEdge(layeredGraph);
                    dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                    LPort startPort = child.getPorts(PortSide.WEST).iterator().next();
                    dummyEdge.setSource(startPort);
                    dummyEdge.setTarget(dummyConnectionPort);
                }
                newPort.setNode(newLowerCompoundPort);
                layeredGraph.getLayerlessNodes().add(newLowerCompoundPort);
                break;
            }
            case LOWER_COMPOUND_BORDER: {
                LNode upperBorder = (LNode)node.getProperty(Properties.COMPOUND_NODE);
                newPort.setNode(upperBorder);
                upperBorder.getSize().y += (double)edgeSpacing;
                break;
            }
            case LOWER_COMPOUND_PORT: {
                LNode newUpperCompoundPort = new LNode(layeredGraph);
                newUpperCompoundPort.copyProperties((IPropertyHolder)node);
                newUpperCompoundPort.setProperty(Properties.NODE_TYPE, (Object)NodeType.UPPER_COMPOUND_PORT);
                newUpperCompoundPort.setProperty(Properties.COMPOUND_NODE, node.getProperty(Properties.COMPOUND_NODE));
                LPort dummyConnector = new LPort(layeredGraph);
                dummyConnector.setSide(PortSide.EAST);
                dummyConnector.setNode(newUpperCompoundPort);
                for (LNode child : Util.getChildren(node)) {
                    LEdge dummyEdge = new LEdge(layeredGraph);
                    dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                    LPort endPort = child.getPorts(PortSide.EAST).iterator().next();
                    dummyEdge.setSource(dummyConnector);
                    dummyEdge.setTarget(endPort);
                }
                newPort.setNode(newUpperCompoundPort);
                layeredGraph.getLayerlessNodes().add(newUpperCompoundPort);
                layeredGraph.getLayerlessNodes().remove(node);
                break;
            }
        }
        return newPort;
    }
}

