/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.SemanticLayoutConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutInfoService {
    protected static final String EXTP_ID_LAYOUT_INFO = "de.cau.cs.kieler.kiml.layoutInfo";
    protected static final String ELEMENT_BINDING = "binding";
    protected static final String ELEMENT_DIAGRAM_TYPE = "diagramType";
    protected static final String ELEMENT_OPTION = "option";
    protected static final String ELEMENT_SEMANTIC_OPTION = "semanticOption";
    protected static final String ELEMENT_CONFIG = "config";
    protected static final String ATTRIBUTE_ACTIVATION = "activation";
    protected static final String ATTRIBUTE_ACTIVATION_ACTION = "activationAction";
    protected static final String ATTRIBUTE_ACTIVATION_TEXT = "activationText";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_CONFIG = "config";
    protected static final String ATTRIBUTE_DEFAULT = "default";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_OPTION = "option";
    protected static final String ATTRIBUTE_VALUE = "value";
    private static LayoutInfoService instance;
    private final Map<String, String> diagramTypeMap = Maps.newLinkedHashMap();
    private final Map<String, Map<String, Object>> id2OptionsMap = Maps.newHashMap();
    private final Multimap<String, SemanticLayoutConfig> semanticConfigMap = HashMultimap.create();
    private final List<ConfigData> configData = Lists.newLinkedList();
    private final MapPropertyHolder configProperties = new MapPropertyHolder();

    public static LayoutInfoService getInstance() {
        return instance;
    }

    protected LayoutInfoService() {
        instance = this;
    }

    public IPropertyHolder getConfigProperties() {
        return this.configProperties;
    }

    protected abstract void reportError(String var1, IConfigurationElement var2, String var3, Throwable var4);

    protected abstract void reportError(CoreException var1);

    protected void loadLayoutInfoExtensions() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_INFO);
        LayoutDataService layoutDataService = LayoutDataService.getInstance();
        assert (layoutDataService != null);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block28: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (ELEMENT_DIAGRAM_TYPE.equals(element.getName())) {
                    String id = element.getAttribute(ATTRIBUTE_ID);
                    String name = element.getAttribute(ATTRIBUTE_NAME);
                    if (id == null || id.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_INFO, element, ATTRIBUTE_ID, null);
                    } else if (name == null) {
                        this.reportError(EXTP_ID_LAYOUT_INFO, element, ATTRIBUTE_NAME, null);
                    } else {
                        this.addDiagramType(id, name);
                    }
                } else if ("option".equals(element.getName())) {
                    String clazz = element.getAttribute(ATTRIBUTE_CLASS);
                    String option = element.getAttribute("option");
                    String valueString = element.getAttribute(ATTRIBUTE_VALUE);
                    if (clazz == null || clazz.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_INFO, element, ATTRIBUTE_CLASS, null);
                    } else if (option == null || option.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_INFO, element, "option", null);
                    } else {
                        LayoutOptionData optionData = layoutDataService.getOptionData(option);
                        if (optionData != null) {
                            try {
                                Object value = optionData.parseValue(valueString);
                                if (value != null) {
                                    this.addOptionValue(clazz, option, value);
                                }
                            }
                            catch (IllegalStateException exception) {
                                this.reportError(EXTP_ID_LAYOUT_INFO, element, ATTRIBUTE_VALUE, exception);
                            }
                        }
                    }
                } else if (ELEMENT_SEMANTIC_OPTION.equals(element.getName())) {
                    try {
                        SemanticLayoutConfig config = (SemanticLayoutConfig)element.createExecutableExtension("config");
                        String clazz = element.getAttribute(ATTRIBUTE_CLASS);
                        if (clazz == null || clazz.length() == 0) {
                            this.reportError(EXTP_ID_LAYOUT_INFO, element, ATTRIBUTE_CLASS, null);
                            break block28;
                        }
                        this.addSemanticConfig(clazz, config);
                    }
                    catch (CoreException exception) {
                        this.reportError(exception);
                    }
                } else if ("config".equals(element.getName())) {
                    try {
                        ConfigData data = new ConfigData();
                        data.config = (ILayoutConfig)element.createExecutableExtension(ATTRIBUTE_CLASS);
                        String activationId = element.getAttribute(ATTRIBUTE_ACTIVATION);
                        if (activationId != null) {
                            String def = element.getAttribute(ATTRIBUTE_DEFAULT);
                            Boolean defaultActivation = def == null ? Boolean.FALSE : Boolean.valueOf(def);
                            data.activation = (IProperty)new Property(activationId, (Object)defaultActivation);
                        }
                        String text = element.getAttribute(ATTRIBUTE_ACTIVATION_TEXT);
                        data.activationText = text;
                        if (element.getAttribute(ATTRIBUTE_ACTIVATION_ACTION) != null) {
                            Runnable action = (Runnable)element.createExecutableExtension(ATTRIBUTE_ACTIVATION_ACTION);
                            data.activationAction = action;
                        }
                        this.configData.add(data);
                    }
                    catch (CoreException exception) {
                        this.reportError(exception);
                    }
                }
            }
            ++n2;
        }
    }

    protected final void addDiagramType(String id, String name) {
        this.diagramTypeMap.put(id, name);
    }

    public final void addOptionValue(String id, String optionId, Object value) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(id);
        if (optionsMap == null) {
            optionsMap = new LinkedHashMap<String, Object>();
            this.id2OptionsMap.put(id, optionsMap);
        }
        optionsMap.put(optionId, value);
    }

    public final void removeOptionValue(String id, String optionId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(id);
        if (optionsMap != null) {
            optionsMap.remove(optionId);
        }
    }

    protected final void addSemanticConfig(String clazzName, SemanticLayoutConfig config) {
        this.semanticConfigMap.put((Object)clazzName, (Object)config);
    }

    public final String getDiagramTypeName(String id) {
        return this.diagramTypeMap.get(id);
    }

    public final List<Pair<String, String>> getDiagramTypes() {
        return Pair.fromMap(this.diagramTypeMap);
    }

    public final Map<String, Object> getOptionValues(String objectId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(objectId);
        if (optionsMap != null) {
            return Collections.unmodifiableMap(optionsMap);
        }
        return Collections.emptyMap();
    }

    public final Object getOptionValue(String objectId, String optionId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(objectId);
        if (optionsMap != null) {
            return optionsMap.get(optionId);
        }
        return null;
    }

    public final Map<String, Object> getOptionValues(EClass clazz) {
        if (clazz != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                EClass c;
                Map<String, Object> optionsMap;
                if ((optionsMap = this.id2OptionsMap.get((c = (EClass)classes.removeFirst()).getInstanceTypeName())) != null) {
                    options.putAll(optionsMap);
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
            return options;
        }
        return Collections.emptyMap();
    }

    public final Object getOptionValue(EClass clazz, String optionId) {
        if (clazz != null) {
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                Object value;
                EClass c;
                Map<String, Object> optionsMap;
                if ((optionsMap = this.id2OptionsMap.get((c = (EClass)classes.removeFirst()).getInstanceTypeName())) != null && (value = optionsMap.get(optionId)) != null) {
                    return value;
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
        }
        return null;
    }

    public final List<ILayoutConfig> getSemanticConfigs(EClass clazz) {
        if (clazz != null) {
            LinkedList<ILayoutConfig> configs = new LinkedList<ILayoutConfig>();
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                EClass c;
                if (this.semanticConfigMap.containsKey((Object)(c = (EClass)classes.removeFirst()).getInstanceTypeName())) {
                    configs.addAll(this.semanticConfigMap.get((Object)c.getInstanceTypeName()));
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
            return configs;
        }
        return Collections.emptyList();
    }

    public final List<ILayoutConfig> getActiveConfigs() {
        LinkedList<ILayoutConfig> configs = new LinkedList<ILayoutConfig>();
        for (ConfigData data : this.configData) {
            if (data.activation != null && !((Boolean)this.configProperties.getProperty(data.activation)).booleanValue()) continue;
            configs.add(data.config);
        }
        return configs;
    }

    public final List<ConfigData> getConfigData() {
        return this.configData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigData {
        private ILayoutConfig config;
        private IProperty<Boolean> activation;
        private String activationText;
        private Runnable activationAction;

        public ILayoutConfig getConfig() {
            return this.config;
        }

        public IProperty<Boolean> getActivationProperty() {
            return this.activation;
        }

        public String getActivationText() {
            return this.activationText;
        }

        public Runnable getActivationAction() {
            return this.activationAction;
        }

        public String toString() {
            if (this.config == null) {
                return super.toString();
            }
            return this.config.getClass().getSimpleName();
        }
    }
}

