/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BendsAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.bendpointCount";

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Number of Bends analysis", 1.0f);
        HashSet<KVector> uniqueBendPoints = new HashSet<KVector>();
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int min = Integer.MAX_VALUE;
        float avg = 0.0f;
        int max = 0;
        int nonUniqueSum = 0;
        int edges = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            for (KEdge edge : node.getOutgoingEdges()) {
                if (!hierarchy && edge.getTarget().getParent() != parentNode) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                EList bendPoints = edgeLayout.getBendPoints();
                for (KPoint bendPoint : bendPoints) {
                    uniqueBendPoints.add(bendPoint.createVector());
                }
                int current = bendPoints.size();
                min = Math.min(min, current);
                max = Math.max(max, current);
                nonUniqueSum += current;
                ++edges;
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        if (edges > 0) {
            avg = (float)nonUniqueSum / (float)edges;
        } else {
            min = 0;
        }
        progressMonitor.done();
        return new Object[]{min, Float.valueOf(avg), max, uniqueBendPoints.size()};
    }
}

