/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphviz.layouter;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.Command;
import de.cau.cs.kieler.kiml.graphviz.layouter.GraphvizException;
import de.cau.cs.kieler.kiml.graphviz.layouter.GraphvizLayouterPlugin;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizTool {
    public static final String PREF_GRAPHVIZ_EXECUTABLE = "graphviz.executable";
    public static final String PREF_TIMEOUT = "graphviz.timeout";
    public static final int PROCESS_DEF_TIMEOUT = 20000;
    public static final int PROCESS_MIN_TIMEOUT = 200;
    private static final String ARG_COMMAND = "-K";
    private static final String ARG_NOWARNINGS = "-q";
    private static final String ARG_INVERTYAXIS = "-y";
    private static final String[] DEFAULT_LOCS = new String[]{"/opt/local/bin/", "/usr/local/bin/", "/usr/bin/", "/bin/"};
    private Process process;
    private Command command;
    private Watchdog watchdog;
    private InputStream graphvizStream;
    private static final int MAX_ERROR_OUTPUT = 512;
    private static final int PROC_ERROR_TIME = 500;
    private Object nextJob = new Object();

    public GraphvizTool(Command thecommand) {
        if (thecommand == Command.INVALID) {
            throw new IllegalArgumentException("Invalid Graphviz command.");
        }
        this.command = thecommand;
    }

    public void initialize() {
        this.initialize(null);
    }

    public void initialize(List<String> arguments) {
        if (this.watchdog == null) {
            this.watchdog = new Watchdog();
            this.watchdog.setName("Graphviz Watchdog");
            this.watchdog.start();
        }
        if (this.process == null) {
            String dotExecutable = GraphvizTool.getDotExecutable();
            ArrayList args = Lists.newArrayList((Object[])new String[]{dotExecutable, ARG_NOWARNINGS, ARG_INVERTYAXIS, ARG_COMMAND + this.command});
            if (arguments != null) {
                args.addAll(arguments);
            }
            try {
                this.process = Runtime.getRuntime().exec(args.toArray(new String[0]));
            }
            catch (IOException exception) {
                throw new WrappedException((Throwable)exception, "Failed to start Graphviz process. Please check your Graphviz installation.");
            }
        }
    }

    public static String getDotExecutable() {
        IPreferenceStore preferenceStore = GraphvizLayouterPlugin.getDefault().getPreferenceStore();
        String dotExecutable = preferenceStore.getString(PREF_GRAPHVIZ_EXECUTABLE);
        if (!new File(dotExecutable).exists()) {
            boolean foundExec = false;
            String[] stringArray = DEFAULT_LOCS;
            int n = DEFAULT_LOCS.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                dotExecutable = String.valueOf(location) + "dot";
                if (new File(dotExecutable).exists()) {
                    foundExec = true;
                    break;
                }
                ++n2;
            }
            if (!foundExec) {
                GraphvizTool.handleExecPath();
                dotExecutable = preferenceStore.getString(PREF_GRAPHVIZ_EXECUTABLE);
            }
        }
        return dotExecutable;
    }

    private static void handleExecPath() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)display.getActiveShell(), (String)"de.cau.cs.kieler.kiml.graphviz.preferences", (String[])new String[0], null);
                preferenceDialog.open();
            }
        });
    }

    public OutputStream input() {
        if (this.process != null) {
            return new BufferedOutputStream(this.process.getOutputStream());
        }
        throw new IllegalStateException("Graphviz tool has not been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream output() {
        if (this.process != null) {
            Object object = this.nextJob;
            synchronized (object) {
                this.graphvizStream = new GraphvizStream(this.process.getInputStream());
                this.nextJob.notify();
            }
            return this.graphvizStream;
        }
        throw new IllegalStateException("Graphviz tool has not been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Cleanup c) {
        StringBuilder error = null;
        if (this.process != null) {
            InputStream errorStream = this.process.getErrorStream();
            try {
                if (c == Cleanup.ERROR) {
                    int exitValue;
                    int ch;
                    Thread.sleep(500L);
                    error = new StringBuilder();
                    do {
                        if ((ch = errorStream.read()) < 0) continue;
                        error.append((char)ch);
                    } while (error.length() < 512 && ch >= 0);
                    if (error.length() == 0 && (exitValue = this.process.exitValue()) != 0) {
                        error.append("Process terminated with exit value " + exitValue + ".");
                    }
                }
                while (errorStream.available() > 0) {
                    errorStream.read();
                }
            }
            catch (Exception exception) {}
            if (c == Cleanup.ERROR || c == Cleanup.STOP) {
                try {
                    this.process.getOutputStream().close();
                    this.process.getInputStream().close();
                }
                catch (IOException iOException) {}
                this.process.destroy();
                this.process = null;
            }
        }
        if (error == null) {
            Object object = this.nextJob;
            synchronized (object) {
                this.graphvizStream = null;
                if (this.watchdog != null) {
                    this.watchdog.interrupt();
                    if (c == Cleanup.STOP) {
                        this.watchdog = null;
                    }
                }
            }
        } else if (error.length() > 0) {
            throw new GraphvizException("Graphviz error: " + error.toString());
        }
    }

    static /* synthetic */ Object access$0(GraphvizTool graphvizTool) {
        return graphvizTool.nextJob;
    }

    static /* synthetic */ InputStream access$1(GraphvizTool graphvizTool) {
        return graphvizTool.graphvizStream;
    }

    static /* synthetic */ Watchdog access$2(GraphvizTool graphvizTool) {
        return graphvizTool.watchdog;
    }

    static /* synthetic */ Process access$3(GraphvizTool graphvizTool) {
        return graphvizTool.process;
    }

    static /* synthetic */ void access$4(GraphvizTool graphvizTool, InputStream inputStream) {
        graphvizTool.graphvizStream = inputStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cleanup {
        NORMAL,
        ERROR,
        STOP;

    }

    private static class GraphvizStream
    extends InputStream {
        private InputStream stream;
        private int depth = 0;
        private int finished = 0;
        private int buf = -1;

        GraphvizStream(InputStream thestream) {
            this.stream = thestream;
        }

        public int read() throws IOException {
            if (this.buf >= 0) {
                int c = this.buf;
                this.buf = -1;
                return c;
            }
            if (this.finished > 0 && this.stream.available() == 0) {
                return -1;
            }
            int c = this.stream.read();
            if (c == 123) {
                ++this.depth;
            } else if (c == 125) {
                --this.depth;
                if (this.depth == 0) {
                    ++this.finished;
                }
            } else if (c == 92) {
                this.buf = this.stream.read();
                if (this.buf == 10 || this.buf == 13) {
                    c = this.stream.read();
                    if (this.buf == 13 && c == 10) {
                        c = this.stream.read();
                    }
                    this.buf = -1;
                }
            }
            return c;
        }

        public int available() throws IOException {
            return this.stream.available();
        }
    }

    private class Watchdog
    extends Thread {
        private Watchdog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            do {
                block17: {
                    var1_1 = GraphvizTool.access$0(GraphvizTool.this);
                    synchronized (var1_1) {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            if (GraphvizTool.access$1(GraphvizTool.this) != null) {
                                break block17;
                            }
                            try {
                                GraphvizTool.access$0(GraphvizTool.this).wait();
                            }
                            catch (InterruptedException v0) {
                                if (GraphvizTool.access$2(GraphvizTool.this) == null) ** break;
                                continue;
                                return;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                }
                preferenceStore = GraphvizLayouterPlugin.getDefault().getPreferenceStore();
                timeout = preferenceStore.getInt("graphviz.timeout");
                if (timeout < 200) {
                    timeout = 20000;
                }
                interrupted = false;
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException v2) {
                    interrupted = true;
                }
                if (interrupted) continue;
                var4_4 = GraphvizTool.access$0(GraphvizTool.this);
                synchronized (var4_4) {
                    myProcess = GraphvizTool.access$3(GraphvizTool.this);
                    if (myProcess != null) {
                        try {
                            myProcess.getInputStream().close();
                            myProcess.getErrorStream().close();
                            GraphvizTool.access$4(GraphvizTool.this, null);
                        }
                        catch (IOException v3) {}
                    }
                }
            } while (GraphvizTool.access$2(GraphvizTool.this) != null);
        }
    }
}

