/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.diagram.DiagramLayoutEngine;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.views.DiagramDefaultAction;
import de.cau.cs.kieler.kiml.ui.views.DiagramPartDefaultAction;
import de.cau.cs.kieler.kiml.ui.views.DiagramTypeDefaultAction;
import de.cau.cs.kieler.kiml.ui.views.LayoutPropertySourceProvider;
import de.cau.cs.kieler.kiml.ui.views.RemoveOptionsAction;
import de.cau.cs.kieler.kiml.ui.views.SelectionInfoAction;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutViewPart
extends ViewPart
implements ISelectionListener {
    public static final String VIEW_ID = "de.cau.cs.kieler.kiml.views.layout";
    public static final String PREF_CATEGORIES = "view.categories";
    public static final String PREF_ADVANCED = "view.advanced";
    private static final String TITLE_FONT = "de.cau.cs.kieler.kiml.ui.views.LayoutViewPart.TITLE_FONT";
    private FormToolkit toolkit;
    private Form form;
    private PropertySheetPage page;
    private final LayoutPropertySourceProvider propSourceProvider = new LayoutPropertySourceProvider();
    private final IPartListener partListener = new IPartListener(){

        public void partClosed(IWorkbenchPart part) {
            if (LayoutViewPart.this.propSourceProvider.getWorkbenchPart() == part) {
                LayoutViewPart.this.propSourceProvider.resetContext();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private static final int MARGIN_WIDTH = 4;
    private static final int FORM_LEFT = 0;
    private static final int FORM_RIGHT = 100;
    private static final int FORM_TOP = 0;
    private static final int FORM_BOTTOM = 100;

    public static LayoutViewPart findView() {
        if (Display.getCurrent() == null) {
            final Maybe part = new Maybe();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    part.set((Object)LayoutViewPart.findViewUI());
                }
            });
            return (LayoutViewPart)((Object)part.get());
        }
        return LayoutViewPart.findViewUI();
    }

    private static LayoutViewPart findViewUI() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return (LayoutViewPart)activePage.findView(VIEW_ID);
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage activePage;
        ActionContributionItem advancedItem;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        this.form.setText("");
        if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
            FontData[] fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData();
            fontData[0].setHeight(fontData[0].getHeight() + 2);
            JFaceResources.getFontRegistry().put(TITLE_FONT, fontData);
        }
        this.form.setFont(JFaceResources.getFont((String)TITLE_FONT));
        Composite content = this.form.getBody();
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 4;
        content.setLayout((Layout)contentLayout);
        this.page = new PropertySheetPage();
        this.page.setRootEntry((IPropertySheetEntry)new PropertySheetEntry());
        this.page.createControl(content);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, 0);
        this.page.getControl().setLayoutData((Object)formData);
        this.page.setPropertySourceProvider((IPropertySourceProvider)this.propSourceProvider);
        IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.page.setActionBars(actionBars);
        this.addPopupActions(this.page.getControl().getMenu());
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)new RemoveOptionsAction(this, Messages.getString("kiml.ui.30")));
        EclipseLayoutInfoService.getInstance().fillConfigMenu(menuManager);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new SelectionInfoAction(this, Messages.getString("kiml.ui.37")));
        ActionContributionItem categoriesItem = (ActionContributionItem)actionBars.getToolBarManager().find("categories");
        if (categoriesItem != null) {
            categoriesItem.getAction().setChecked(preferenceStore.getBoolean(PREF_CATEGORIES));
            categoriesItem.getAction().run();
        }
        if ((advancedItem = (ActionContributionItem)actionBars.getToolBarManager().find("filter")) != null) {
            advancedItem.getAction().setChecked(preferenceStore.getBoolean(PREF_ADVANCED));
            advancedItem.getAction().run();
        }
        if ((activePage = (workbenchWindow = this.getSite().getWorkbenchWindow()).getActivePage()) != null) {
            final IWorkbenchPart activePart = activePage.getActivePart();
            final ISelection selection = workbenchWindow.getSelectionService().getSelection();
            if (activePart != null && selection != null) {
                workbenchWindow.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        LayoutViewPart.this.selectionChanged(activePart, selection);
                    }
                });
            }
        }
        workbenchWindow.getSelectionService().addSelectionListener((ISelectionListener)this);
        workbenchWindow.getPartService().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.page.setFocus();
    }

    public Control getControl() {
        return this.page.getControl();
    }

    public void dispose() {
        ActionContributionItem advancedItem;
        ActionContributionItem categoriesItem = (ActionContributionItem)this.getViewSite().getActionBars().getToolBarManager().find("categories");
        if (categoriesItem != null) {
            KimlUiPlugin.getDefault().getPreferenceStore().setValue(PREF_CATEGORIES, categoriesItem.getAction().isChecked());
        }
        if ((advancedItem = (ActionContributionItem)this.getViewSite().getActionBars().getToolBarManager().find("filter")) != null) {
            KimlUiPlugin.getDefault().getPreferenceStore().setValue(PREF_ADVANCED, advancedItem.getAction().isChecked());
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.propSourceProvider.resetContext(null);
        this.toolkit.dispose();
        super.dispose();
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LayoutViewPart.this.propSourceProvider.resetContext();
                LayoutViewPart.this.page.refresh();
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDiagramLayoutManager<?> manager = EclipseLayoutInfoService.getInstance().getManager(part, null);
        if (manager != null) {
            this.propSourceProvider.resetContext(part);
            this.page.selectionChanged(part, selection);
            this.setPartText();
        }
    }

    public List<IPropertySheetEntry> getSelection() {
        TreeItem[] treeItems;
        LinkedList<IPropertySheetEntry> entries = new LinkedList<IPropertySheetEntry>();
        TreeItem[] treeItemArray = treeItems = ((Tree)this.page.getControl()).getSelection();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add((IPropertySheetEntry)data);
            } else {
                TreeItem[] treeItemArray2 = item.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem childItem = treeItemArray2[n4];
                    data = childItem.getData();
                    if (data instanceof IPropertySheetEntry) {
                        entries.add((IPropertySheetEntry)data);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return entries;
    }

    private void addPopupActions(final Menu menu) {
        final DiagramDefaultAction applyOptionAction = new DiagramDefaultAction(this, Messages.getString("kiml.ui.10"));
        final DiagramPartDefaultAction diagramPartDefaultAction = new DiagramPartDefaultAction(this, "", false);
        final DiagramPartDefaultAction modelDefaultAction = new DiagramPartDefaultAction(this, "", true);
        final DiagramTypeDefaultAction diagramTypeDefaultAction = new DiagramTypeDefaultAction(this, "");
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                MenuItem diagramDefaultItem = null;
                MenuItem diagramTypeDefaultItem = null;
                MenuItem diagramPartDefaultItem = null;
                MenuItem modelDefaultItem = null;
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    if (item.getData() instanceof IContributionItem) {
                        String itemId = ((IContributionItem)item.getData()).getId();
                        if ("kieler.diagram.default".equals(itemId)) {
                            diagramDefaultItem = item;
                        } else if ("kieler.edit.part.default".equals(itemId)) {
                            diagramPartDefaultItem = item;
                        } else if ("kieler.model.default".equals(itemId)) {
                            modelDefaultItem = item;
                        } else if ("kieler.diagram.type.default".equals(itemId)) {
                            diagramTypeDefaultItem = item;
                        }
                    }
                    ++n2;
                }
                if (LayoutViewPart.this.propSourceProvider.hasContent()) {
                    if (diagramDefaultItem == null) {
                        ActionContributionItem contributionItem = new ActionContributionItem((IAction)applyOptionAction);
                        contributionItem.setId("kieler.diagram.default");
                        contributionItem.fill(menu, -1);
                    } else {
                        diagramDefaultItem.setEnabled(true);
                    }
                } else if (diagramDefaultItem != null) {
                    diagramDefaultItem.setEnabled(false);
                }
                String diagramPartName = LayoutViewPart.this.getReadableName(false, true);
                if (diagramPartName != null && LayoutViewPart.this.propSourceProvider.hasContent()) {
                    if (diagramPartDefaultItem == null) {
                        diagramPartDefaultAction.setText(String.valueOf(Messages.getString("kiml.ui.16")) + " " + diagramPartName);
                        ActionContributionItem contributionItem = new ActionContributionItem((IAction)diagramPartDefaultAction);
                        contributionItem.setId("kieler.edit.part.default");
                        contributionItem.fill(menu, -1);
                    } else {
                        diagramPartDefaultItem.setEnabled(true);
                        diagramPartDefaultItem.setText(String.valueOf(Messages.getString("kiml.ui.16")) + " " + diagramPartName);
                    }
                } else if (diagramPartDefaultItem != null) {
                    diagramPartDefaultItem.setEnabled(false);
                }
                String modelName = LayoutViewPart.this.getReadableName(true, true);
                if (modelName != null && LayoutViewPart.this.propSourceProvider.hasContent()) {
                    if (modelDefaultItem == null) {
                        modelDefaultAction.setText(String.valueOf(Messages.getString("kiml.ui.34")) + " " + modelName);
                        ActionContributionItem contributionItem = new ActionContributionItem((IAction)modelDefaultAction);
                        contributionItem.setId("kieler.model.default");
                        contributionItem.fill(menu, -1);
                    } else {
                        modelDefaultItem.setEnabled(true);
                        modelDefaultItem.setText(String.valueOf(Messages.getString("kiml.ui.34")) + " " + modelName);
                    }
                } else if (modelDefaultItem != null) {
                    modelDefaultItem.setEnabled(false);
                }
                LayoutOptionData diagramTypeOption = LayoutDataService.getInstance().getOptionData(LayoutOptions.DIAGRAM_TYPE.getId());
                LayoutContext context = LayoutViewPart.this.propSourceProvider.getContext();
                IMutableLayoutConfig config = DiagramLayoutEngine.INSTANCE.getOptionManager().createConfig((EObject)context.getProperty(LayoutContext.DOMAIN_MODEL), new ILayoutConfig[0]);
                String diagramType = (String)config.getValue(diagramTypeOption, context);
                String diagramTypeName = EclipseLayoutInfoService.getInstance().getDiagramTypeName(diagramType);
                if (diagramTypeName != null) {
                    String dtdText = diagramTypeName.endsWith("s") ? String.valueOf(Messages.getString("kiml.ui.34")) + " " + diagramTypeName : String.valueOf(Messages.getString("kiml.ui.34")) + " " + diagramTypeName + "s";
                    if (diagramTypeDefaultItem == null) {
                        diagramTypeDefaultAction.setText(dtdText);
                        ActionContributionItem contributionItem = new ActionContributionItem((IAction)diagramTypeDefaultAction);
                        contributionItem.setId("kieler.diagram.type.default");
                        contributionItem.fill(menu, -1);
                    } else {
                        diagramTypeDefaultItem.setEnabled(true);
                        diagramTypeDefaultItem.setText(dtdText);
                    }
                    diagramTypeDefaultAction.setDiagramType(diagramType);
                } else if (diagramTypeDefaultItem != null) {
                    diagramTypeDefaultItem.setEnabled(false);
                }
            }
        });
    }

    private String getReadableName(boolean forDomainModel, boolean plural) {
        int lastDotIndex;
        String clazzName;
        if (!this.propSourceProvider.hasContent()) {
            return "";
        }
        LayoutContext context = this.propSourceProvider.getContext();
        EObject model = (EObject)context.getProperty(LayoutContext.DOMAIN_MODEL);
        Object diagramPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        String string = clazzName = model == null ? null : model.eClass().getInstanceTypeName();
        if (clazzName == null) {
            if (plural || diagramPart == null) {
                return null;
            }
            clazzName = diagramPart.getClass().getName();
            if (clazzName.endsWith("EditPart")) {
                clazzName = clazzName.substring(0, clazzName.length() - "EditPart".length());
            }
        }
        if ((lastDotIndex = clazzName.lastIndexOf(46)) >= 0) {
            clazzName = clazzName.substring(lastDotIndex + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = clazzName.length();
        if (clazzName.endsWith("Impl")) {
            length -= "Impl".length();
        }
        int i = 0;
        while (i < length) {
            char c = clazzName.charAt(i);
            if (i > 0 && Character.isUpperCase(c) && !Character.isUpperCase(clazzName.charAt(i - 1))) {
                stringBuilder.append(' ');
            }
            if (!Character.isDigit(c)) {
                stringBuilder.append(c);
            }
            ++i;
        }
        if (plural && !clazzName.endsWith("s")) {
            stringBuilder.append('s');
        }
        if (!forDomainModel) {
            stringBuilder.append(" " + Messages.getString("kiml.ui.33"));
        }
        return stringBuilder.toString();
    }

    public Object getCurrentDiagramPart() {
        if (this.propSourceProvider.hasContent()) {
            return this.propSourceProvider.getContext().getProperty(LayoutContext.DIAGRAM_PART);
        }
        return null;
    }

    public IWorkbenchPart getCurrentWorkbenchPart() {
        return this.propSourceProvider.getWorkbenchPart();
    }

    public LayoutAlgorithmData[] getCurrentLayouterData() {
        HashSet<LayoutAlgorithmData> data = new HashSet<LayoutAlgorithmData>(4);
        LayoutContext context = this.propSourceProvider.getContext();
        LayoutAlgorithmData lad = (LayoutAlgorithmData)context.getProperty(DefaultLayoutConfig.CONTENT_ALGO);
        if (lad != null) {
            data.add(lad);
        }
        if ((lad = (LayoutAlgorithmData)context.getProperty(DefaultLayoutConfig.CONTAINER_ALGO)) != null) {
            data.add(lad);
        }
        return data.toArray(new LayoutAlgorithmData[data.size()]);
    }

    private void setPartText() {
        if (this.propSourceProvider.hasContent()) {
            EObject model;
            StringBuilder textBuffer = new StringBuilder();
            String name = this.getReadableName(true, false);
            if (name != null) {
                textBuffer.append(name);
            }
            if ((model = (EObject)this.propSourceProvider.getContext().getProperty(LayoutContext.DOMAIN_MODEL)) != null) {
                String modelName = LayoutViewPart.getProperty(model, "Name");
                if (modelName == null) {
                    modelName = LayoutViewPart.getProperty(model, "Label");
                }
                if (modelName == null) {
                    modelName = LayoutViewPart.getProperty(model, "Id");
                }
                if (modelName != null) {
                    textBuffer.append(" '" + modelName + "'");
                }
            }
            this.form.setText(textBuffer.toString());
        } else {
            this.form.setText("");
        }
    }

    private static String getProperty(Object object, String property) {
        try {
            return (String)object.getClass().getMethod("get" + property, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

