/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.util.KimlUiUtil;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveOptionsAction
extends Action {
    private LayoutViewPart layoutView;

    public RemoveOptionsAction(LayoutViewPart thelayoutView, String text) {
        super(text);
        this.layoutView = thelayoutView;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.layoutView.getCurrentWorkbenchPart();
        IDiagramLayoutManager<?> manager = EclipseLayoutInfoService.getInstance().getManager(workbenchPart, null);
        if (manager != null) {
            Object diagramPart = manager.getAdapter(workbenchPart, manager.getAdapterList()[0]);
            IMutableLayoutConfig layoutConfig = (IMutableLayoutConfig)manager.getAdapter(null, IMutableLayoutConfig.class);
            EditingDomain editingDomain = (EditingDomain)manager.getAdapter(workbenchPart, EditingDomain.class);
            if (diagramPart != null && layoutConfig != null && editingDomain != null) {
                LayoutContext context = new LayoutContext();
                context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
                context.setProperty(IMutableLayoutConfig.OPT_RECURSIVE, (Object)true);
                layoutConfig.enrich(context);
                this.removeOptions(workbenchPart.getTitle(), layoutConfig, context, editingDomain);
            }
        }
    }

    private void removeOptions(String diagramName, final IMutableLayoutConfig layoutConfig, final LayoutContext context, EditingDomain editingDomain) {
        boolean userResponse = MessageDialog.openQuestion((Shell)this.layoutView.getSite().getShell(), (String)Messages.getString("kiml.ui.31"), (String)(String.valueOf(Messages.getString("kiml.ui.32")) + " " + diagramName + "?"));
        if (userResponse) {
            Runnable runnable = new Runnable(){

                public void run() {
                    layoutConfig.clearValues(context);
                }
            };
            KimlUiUtil.runModelChange(runnable, (TransactionalEditingDomain)editingDomain, Messages.getString("kiml.ui.30"));
            LayoutViewPart viewPart = LayoutViewPart.findView();
            if (viewPart != null) {
                viewPart.refresh();
            }
        }
    }
}

