/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.model;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.graph.FNode;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import de.cau.cs.kieler.klay.force.model.AbstractForceModel;
import de.cau.cs.kieler.klay.force.properties.Properties;

public class FruchtermanReingoldModel
extends AbstractForceModel {
    private static final double SPACING_FACTOR = 0.01;
    private static final double ZERO_FACTOR = 100.0;
    private double temperature = ((Float)Properties.TEMPERATURE.getDefault()).floatValue();
    private double threshold;
    private double k;

    protected void initialize(FGraph graph) {
        super.initialize(graph);
        this.temperature = ((Float)graph.getProperty((IProperty)Properties.TEMPERATURE)).floatValue();
        this.threshold = this.temperature / (double)((Integer)graph.getProperty((IProperty)Properties.ITERATIONS)).intValue();
        int n = graph.getNodes().size();
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (FNode v : graph.getNodes()) {
            totalWidth += v.getSize().x;
            totalHeight += v.getSize().y;
        }
        double area = totalWidth * totalHeight;
        double c = (double)((Float)graph.getProperty((IProperty)Properties.SPACING)).floatValue() * 0.01;
        this.k = Math.sqrt(area / (double)(2 * n)) * c;
    }

    protected boolean moreIterations(int count) {
        return this.temperature > 0.0;
    }

    protected KVector calcDisplacement(FParticle forcer, FParticle forcee) {
        FruchtermanReingoldModel.avoidSamePosition(this.getRandom(), forcer, forcee);
        KVector displacement = forcee.getPosition().differenceCreate(forcer.getPosition());
        double length = displacement.getLength();
        double d = Math.max(0.0, length - forcer.getRadius() - forcee.getRadius());
        double force = FruchtermanReingoldModel.repulsive(d, this.k) * (double)((Integer)forcer.getProperty((IProperty)Properties.PRIORITY)).intValue();
        int connection = this.getGraph().getConnection(forcer, forcee);
        if (connection > 0) {
            force -= FruchtermanReingoldModel.attractive(d, this.k) * (double)connection;
        }
        displacement.scale(force * this.temperature / length);
        return displacement;
    }

    protected void iterationDone() {
        super.iterationDone();
        this.temperature -= this.threshold;
    }

    private static double repulsive(double d, double k) {
        if (d > 0.0) {
            return k * k / d;
        }
        return k * k * 100.0;
    }

    public static double attractive(double d, double k) {
        return d * d / k;
    }
}

