/*
 * KIELER - Kiel Integrated Environment for Layout Eclipse RichClient
 *
 * http://www.informatik.uni-kiel.de/rtsys/kieler/
 * 
 * Copyright 2011 by
 * + Christian-Albrechts-University of Kiel
 *   + Department of Computer Science
 *     + Real-Time and Embedded Systems Group
 * 
 * This code is provided under the terms of the Eclipse Public License (EPL).
 * See the file epl-v10.html for the license text.
 */

package de.cau.cs.kieler.kiml.service.grana.analyses;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;

/**
 * A graph analysis that gives the number of self loops in the graph. Returns a
 * single-component result {@code (int selfLoops)}.
 * 
 * This analysis does not yet take into account indirect self loops, e.g. paths
 * from a node to itself that only contain hyper nodes. It is not clear if these
 * kinds of self loops should be included or not.
 * 
 * @author cds
 * @kieler.rating proposed yellow 2012-07-10 msp
 */
public class SelfLoopAnalysis implements IAnalysis {
    
    /** identifier of the self-loops analysis. */
    public static final String ID = "de.cau.cs.kieler.kiml.grana.selfLoops";

    /**
     * {@inheritDoc}
     */
    public Object doAnalysis(final KNode parentNode, final Map<String, Object> results,
            final IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-loop analysis", 1);
        
        boolean hierarchy = parentNode.getData(KShapeLayout.class).getProperty(
                AnalysisOptions.ANALYZE_HIERARCHY);
        
        List<KNode> nodeQueue = new LinkedList<KNode>();
        nodeQueue.addAll(parentNode.getChildren());
        int selfLoops = 0;
        while (!nodeQueue.isEmpty()) {
            KNode node = nodeQueue.remove(0);
            
            // Count this node's self loops
            for (KEdge edge : node.getOutgoingEdges()) {
                if (edge.getTarget().equals(node)) {
                    selfLoops++;
                }
            }
            
            if (hierarchy) {
                nodeQueue.addAll(node.getChildren());
            }
        }
        
        progressMonitor.done();
        
        return selfLoops;
    }

}
