/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.web.internal.template.ServiceCallback;
import org.eclipse.gemini.web.internal.template.ServiceTemplate;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SystemBundleExportsResolver {
    private final BundleContext bundleContext;

    SystemBundleExportsResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Map<String, VersionRange> getSystemBundleExports() {
        final Bundle systemBundle = this.bundleContext.getBundle(0L);
        ServiceTemplate<PackageAdmin> packageAdminTemplate = new ServiceTemplate<PackageAdmin>(this.bundleContext, PackageAdmin.class);
        packageAdminTemplate.start();
        ExportedPackage[] systemBundleExports = packageAdminTemplate.executeWithService(new ServiceCallback<PackageAdmin, ExportedPackage[]>(){

            @Override
            public ExportedPackage[] doWithService(PackageAdmin packageAdmin) {
                return packageAdmin.getExportedPackages(systemBundle);
            }
        });
        packageAdminTemplate.stop();
        return SystemBundleExportsResolver.combineDuplicateExports(systemBundleExports);
    }

    static Map<String, VersionRange> combineDuplicateExports(ExportedPackage[] allExportedPackages) {
        HashMap<String, VersionRange> exportedPackages = new HashMap<String, VersionRange>();
        ExportedPackage[] exportedPackageArray = allExportedPackages;
        int n = allExportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage exportedPackage = exportedPackageArray[n2];
            VersionRange versionRange = (VersionRange)exportedPackages.get(exportedPackage.getName());
            if (versionRange == null) {
                versionRange = VersionRange.createExactRange((Version)exportedPackage.getVersion());
            } else {
                Version version = exportedPackage.getVersion();
                if (!versionRange.includes(version)) {
                    versionRange = SystemBundleExportsResolver.expandVersionRange(version, versionRange);
                }
            }
            exportedPackages.put(exportedPackage.getName(), versionRange);
            ++n2;
        }
        return exportedPackages;
    }

    private static VersionRange expandVersionRange(Version version, VersionRange versionRange) {
        Version ceiling = versionRange.getCeiling();
        if (version.compareTo((Object)ceiling) > 0) {
            return new VersionRange("[" + versionRange.getFloor() + "," + version + "]");
        }
        return new VersionRange("[" + version + "," + versionRange.getCeiling() + "]");
    }
}

