/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.support;

import java.io.File;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EquinoxBundleFileResolver
implements BundleFileResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquinoxBundleFileResolver.class);

    EquinoxBundleFileResolver() {
    }

    @Override
    public File resolve(Bundle bundle) {
        BundleHost bh;
        BundleData bundleData;
        if (bundle instanceof BundleHost && (bundleData = (bh = (BundleHost)bundle).getBundleData()) instanceof BaseData) {
            File file = ((BaseData)bundleData).getBundleFile().getBaseFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved bundle '" + bundle.getSymbolicName() + "' to file '" + file.getAbsolutePath() + "'");
            }
            return file;
        }
        return null;
    }

    public static boolean canUse() {
        try {
            EquinoxBundleFileResolver.class.getClassLoader().loadClass(BundleHost.class.getName());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (LinkageError linkageError) {
            return false;
        }
    }
}

