/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.tags.handlers.impl.config.IDeferredParameterValue;
import org.eclipse.gendoc.tags.handlers.impl.config.IDeferredValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParameterValue
implements IDeferredParameterValue {
    private static final String KEY_INPUT = "input";
    private static final String KEY_DATE = "date";

    @Override
    public Map<String, String> getValue() {
        HashMap<String, String> result = new HashMap<String, String>();
        Date actual = Calendar.getInstance().getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        result.put(KEY_DATE, format.format(actual));
        return result;
    }

    @Override
    public Map<String, IDeferredValue> getDeferredValues() {
        HashMap<String, IDeferredValue> result = new HashMap<String, IDeferredValue>();
        IDeferredValue documentDeferred = new IDeferredValue(){
            String documentName = null;

            public String get() {
                if (this.documentName == null) {
                    try {
                        IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
                        if (docService != null) {
                            String name = docService.getDocument().getPath().substring(docService.getDocument().getPath().lastIndexOf(47) + 1, docService.getDocument().getPath().length());
                            this.documentName = name.substring(0, name.lastIndexOf("."));
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                }
                return this.documentName;
            }
        };
        result.put(KEY_INPUT, documentDeferred);
        return result;
    }
}

