/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard.popup.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.wizard.GendocWizard;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocSelectionConverterRunner;
import org.eclipse.gendoc.wizard.Utils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateDocumentationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selec = (IStructuredSelection)selection;
            Object firstElement = selec.getFirstElement();
            List<IGendocRunner> runners = Utils.getRunners(firstElement);
            if (runners == null || runners.isEmpty()) {
                IFile adapted = null;
                if (firstElement instanceof IAdaptable) {
                    IAdaptable iada = (IAdaptable)firstElement;
                    adapted = (IFile)iada.getAdapter(IFile.class);
                }
                if (adapted == null) {
                    adapted = (IFile)Platform.getAdapterManager().getAdapter(firstElement, IFile.class);
                }
                if (adapted != null) {
                    runners = Utils.getRunners(adapted);
                }
            }
            if (runners != null && !runners.isEmpty()) {
                HashSet<IFile> files = new HashSet<IFile>(Arrays.asList(Utils.getIFiles(firstElement)));
                for (IGendocRunner r : runners) {
                    IGendocSelectionConverterRunner converterRunner;
                    if (!(r instanceof IGendocSelectionConverterRunner) || (converterRunner = (IGendocSelectionConverterRunner)r).getSelectionConverter() == null) continue;
                    files.add(converterRunner.getSelectionConverter().getFile(firstElement));
                }
                IFile[] iFiles = files.toArray(new IFile[0]);
                GendocWizard wizard = new GendocWizard(runners, iFiles);
                WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
                wizardDialog.open();
            }
        }
        return null;
    }
}

