/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.Table2Column;
import com.sun.webui.jsf.component.Table2RowGroup;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Table2RowGroupRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String xjson = (String)context.getExternalContext().getRequestHeaderMap().get("X-JSON");
        if (xjson == null) {
            return;
        }
        try {
            Integer first;
            Table2RowGroup group = (Table2RowGroup)component;
            JSONObject json = new JSONObject(xjson);
            if (json != null && (first = (Integer)json.get("first")) != null) {
                group.setFirst(first);
            }
            int maxRows = group.getRows();
            group.setRows(maxRows * 2);
            JSONArray rows = this.getRows(context, group);
            group.setRows(maxRows);
            if (rows != null) {
                rows.write((Writer)context.getResponseWriter());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private JSONArray getRows(FacesContext context, Table2RowGroup component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return null;
        }
        if (component.getRowCount() == 0) {
            return null;
        }
        RowKey[] rowKeys = component.getRenderedRowKeys();
        if (rowKeys == null) {
            return null;
        }
        JSONArray json = new JSONArray();
        try {
            for (int i = 0; i < rowKeys.length; ++i) {
                component.setRowKey(rowKeys[i]);
                if (!component.isRowAvailable()) break;
                JSONArray cols = new JSONArray();
                Iterator kids = component.getTable2ColumnChildren();
                while (kids.hasNext()) {
                    Table2Column col = (Table2Column)kids.next();
                    if (!col.isRendered()) continue;
                    Iterator grandKids = col.getChildren().iterator();
                    while (grandKids.hasNext()) {
                        WidgetUtilities.addProperties(cols, WidgetUtilities.renderComponent(context, (UIComponent)grandKids.next()));
                    }
                }
                json.put((Object)cols);
            }
            component.setRowKey(null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }
}

