/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateDescriptorFilePage
extends WizardNewFileCreationPage {
    private String selectedInstance;
    private boolean isSplit;
    private List<String> repositoryPatterns;
    private List<String> filePatterns;
    private Long timepoint;

    public CreateDescriptorFilePage(IStructuredSelection currentSelection) {
        super("Create new local Hawk model descriptor", currentSelection);
        this.setTitle("Create new local Hawk model descriptor");
        this.setDescription("Select the destination path for the new descriptor.");
    }

    protected InputStream getInitialContents() {
        byte[] bytes;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.selectedInstance);
        sbuf.append(System.lineSeparator());
        sbuf.append("repos");
        sbuf.append("=");
        this.appendAll(sbuf, ",", this.repositoryPatterns);
        sbuf.append(System.lineSeparator());
        sbuf.append("files");
        sbuf.append("=");
        this.appendAll(sbuf, ",", this.filePatterns);
        if (!this.isSplit) {
            sbuf.append(System.lineSeparator());
            sbuf.append("unsplit");
        }
        if (this.timepoint != null) {
            sbuf.append(System.lineSeparator());
            sbuf.append("timepoint");
            sbuf.append("=");
            sbuf.append(this.timepoint);
        }
        try {
            bytes = sbuf.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            bytes = new byte[]{};
        }
        return new ByteArrayInputStream(bytes);
    }

    private void appendAll(StringBuffer sbuf, String sep, List<String> elems) {
        boolean first = true;
        for (String elem : elems) {
            if (first) {
                first = false;
            } else {
                sbuf.append(sep);
            }
            sbuf.append(elem);
        }
    }

    public String getSelectedInstance() {
        return this.selectedInstance;
    }

    public void setSelectedInstance(String selectedInstance) {
        this.selectedInstance = selectedInstance;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public List<String> getRepositoryPatterns() {
        return this.repositoryPatterns;
    }

    public void setRepositoryPatterns(List<String> repositoryPatterns) {
        this.repositoryPatterns = repositoryPatterns;
    }

    public List<String> getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(List<String> filePatterns) {
        this.filePatterns = filePatterns;
    }

    public Long getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(Long timepoint) {
        this.timepoint = timepoint;
    }
}

