/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.syncValidationListener;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.core.runtime.BaseModelIndexer;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.ProxyReferenceTarget;

public class SyncValidationListener
implements IGraphChangeListener {
    private static final double THRESHOLD_DIFFERENT_DOUBLES = 1.0E-4;
    private BaseModelIndexer hawk;
    private List<ValidationError> errors = new ArrayList<ValidationError>();
    private int removedProxies;
    private int deleted;
    private int malformed;
    private int singletonCount;
    private int totalGraphSize;
    private int totalResourceSizes;
    private Set<String> changed = new HashSet<String>();
    private IGraphNodeIndex singletonIndex;
    private boolean singletonIndexIsEmpty;

    public void setModelIndexer(IModelIndexer hawk) {
        this.hawk = (BaseModelIndexer)hawk;
        if (this.hawk != null) {
            System.err.println("SyncValidationListener: hawk.setSyncMetricsEnabled(true) called, performance will suffer!");
            hawk.setSyncMetricsEnabled(Boolean.valueOf(true));
        }
    }

    public String getName() {
        return "Sync Validation Listener";
    }

    public void synchroniseStart() {
    }

    public void synchroniseEnd() {
        try {
            if (this.hawk != null) {
                this.validateChanges();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.deleted = 0;
        this.changed.clear();
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public int getTotalErrors() {
        return this.errors.size();
    }

    private void validateChanges() throws URISyntaxException {
        assert (this.hawk != null) : "validateChanges() should only be called if the indexer has been set";
        System.err.println("sync metrics:");
        System.err.println("interesting\t" + this.hawk.getInterestingFiles());
        System.err.println("deleted\t\t" + this.hawk.getDeletedFiles());
        System.err.println("changed\t\t" + this.hawk.getCurrChangedItems());
        System.err.println("loaded\t\t" + this.hawk.getLoadedResources());
        System.err.println("c elems\t\t" + this.latestChangedElements());
        System.err.println("d elems\t\t" + this.latestDeletedElements());
        System.err.println("time\t\t~" + this.hawk.getLatestSynctime() / 1000L + "s");
        System.err.println("validating changes...");
        this.errors.clear();
        this.removedProxies = 0;
        this.malformed = 0;
        this.singletonCount = 0;
        this.totalResourceSizes = 0;
        this.totalGraphSize = 0;
        URI tempURI = new File(this.hawk.getGraph().getTempDir()).toURI();
        if (this.hawk.getFileToResourceMap() != null) {
            for (VcsCommitItem c : this.hawk.getFileToResourceMap().keySet()) {
                this.validateChanges(tempURI, c);
            }
        }
        System.err.println("changed resource size: " + this.totalResourceSizes);
        System.err.println("relevant graph size: " + this.totalGraphSize + (this.singletonCount > 0 ? " + singleton count: " + this.singletonCount : ""));
        if (this.totalGraphSize + this.singletonCount != this.totalResourceSizes) {
            this.errors.add(new ValidationError(String.format("Mismatched resource size:  %d + %d != %d", this.totalGraphSize, this.singletonCount, this.totalResourceSizes)));
        }
        System.err.println("validated changes... " + (this.errors.isEmpty() ? "true" : String.valueOf(this.errors.size() == this.malformed) + " (with " + this.errors.size() + " total and " + this.malformed + " malformed errors)") + (this.removedProxies == 0 ? "" : " [" + this.removedProxies + "] unresolved hawk proxies matched"));
    }

    protected void validateChanges(URI tempURI, VcsCommitItem c) throws URISyntaxException {
        String repository;
        String repoURL = repository = c.getCommit().getDelta().getManager().getLocation();
        IHawkModelResource r = (IHawkModelResource)this.hawk.getFileToResourceMap().get(c);
        if (r == null) {
            return;
        }
        System.out.println("validating file " + c.getChangeType() + " for " + c.getPath());
        IGraphDatabase graph = this.hawk.getGraph();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                this.singletonIndex = graph.getOrCreateNodeIndex("fragmentdictionary");
                this.singletonIndexIsEmpty = !this.singletonIndex.query("*", (Object)"*").iterator().hasNext();
                String file = null;
                IGraphNode filenode = null;
                try {
                    file = String.valueOf(repository) + "||||" + c.getPath();
                    filenode = (IGraphNode)graph.getFileIndex().get("id", (Object)file).getSingle();
                }
                catch (Exception ee) {
                    this.errors.add(new ValidationError(String.format("Expected file %s but it did not exist (maybe metamodel not registered, if so expect +1 errors)", file)));
                    if (t != null) {
                        t.close();
                    }
                    return;
                }
                HashMap<String, IHawkObject> eObjectCache = new HashMap<String, IHawkObject>();
                HashSet<String> malformedObjectCache = new HashSet<String>();
                this.cacheModelElements(c, r, eObjectCache, malformedObjectCache);
                for (IGraphEdge instanceEdge : filenode.getIncomingWithType("_hawkFile")) {
                    IGraphNode instance = instanceEdge.getStartNode();
                    ++this.totalGraphSize;
                    IHawkObject eobject = (IHawkObject)eObjectCache.get(instance.getProperty("_hawkid"));
                    if (eobject == null) {
                        this.errors.add(new ValidationError(String.format("Graph contains node with identifier: %s but resource does not!", instance.getProperty("_hawkid"))));
                        continue;
                    }
                    eObjectCache.remove(instance.getProperty("_hawkid"));
                    if (malformedObjectCache.contains(eobject.getUri())) continue;
                    this.compareAttributes(instance, eobject);
                    this.compareReferences(tempURI, repoURL, instance, eobject);
                }
                if (eObjectCache.size() > 0) {
                    this.errors.add(new ValidationError(String.format("The following objects were not found in the graph:\n%s", eObjectCache.keySet())));
                }
                t.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("syncValidationListener transaction error:");
            e.printStackTrace();
        }
    }

    protected void cacheModelElements(VcsCommitItem commitItem, IHawkModelResource modelResource, Map<String, IHawkObject> eobjectCache, Set<String> malformedObjectCache) {
        for (IHawkObject content : modelResource.getAllContents()) {
            IHawkObject old = eobjectCache.put(content.getUriFragment(), content);
            if (old != null) {
                if (!this.singletonIndexIsEmpty && this.singletonIndex.get("id", (Object)content.getUriFragment()).iterator().hasNext()) {
                    ++this.singletonCount;
                } else {
                    System.err.println("warning (" + commitItem.getPath() + ") eobjectCache replaced:");
                    System.err.println(String.valueOf(old.getUri()) + " | " + old.getUriFragment() + " | ofType: " + old.getType().getName());
                    System.err.println("with:");
                    System.err.println(String.valueOf(content.getUri()) + " | " + content.getUriFragment() + " | ofType: " + content.getType().getName());
                    malformedObjectCache.add(old.getUri());
                    ++this.malformed;
                    System.err.println("WARNING: MALFORMED MODEL RESOURCE (multiple identical identifiers for:\n" + old.getUri() + "),\nexpect " + this.malformed + " objects in validation.");
                }
            }
            ++this.totalResourceSizes;
        }
    }

    protected void compareReferences(URI tempURI, String repoURL, IGraphNode instance, IHawkObject eobject) throws URISyntaxException {
        Map<String, Set<String>> modelReferences = this.computeModelReferences(tempURI, repoURL, eobject);
        Map<String, Set<String>> nodereferences = this.computeNodeReferences(repoURL, instance);
        for (Map.Entry<String, Set<String>> modelRef : modelReferences.entrySet()) {
            String modelRefName = modelRef.getKey();
            if (!nodereferences.containsKey(modelRefName)) continue;
            HashSet noderefvalues = new HashSet(nodereferences.get(modelRefName));
            HashSet modelrefvalues = new HashSet(modelReferences.get(modelRefName));
            HashSet<String> noderefvaluesclone = new HashSet<String>(noderefvalues);
            noderefvaluesclone.removeAll(modelrefvalues);
            Set<String> modelrefvaluesclone = new HashSet<String>(modelrefvalues);
            modelrefvaluesclone.removeAll(noderefvalues);
            modelrefvaluesclone = this.removeHawkProxies(instance, modelrefvaluesclone);
            this.filterFragmentBasedReferences(noderefvaluesclone, modelrefvaluesclone);
            if (noderefvaluesclone.size() > 0) {
                IGraphNode fileNode = ((IGraphEdge)instance.getOutgoingWithType("_hawkFile").iterator().next()).getEndNode();
                this.errors.add(new ValidationError(String.format("Reference %s of node: %s\nLocated: %s\n%s\nThe above IDs were found in the graph but not the model", modelRefName, instance.getProperty("_hawkid"), fileNode, noderefvaluesclone)));
            }
            if (modelrefvaluesclone.size() > 0) {
                this.errors.add(new ValidationError(String.format("Reference %s of model element: %s\nLocated: %s\n%s\nThe above IDs were found in the model but not the graph", modelRefName, eobject.getUriFragment(), eobject.getUri(), modelrefvaluesclone)));
            }
            nodereferences.remove(modelRefName);
        }
        if (nodereferences.size() > 0) {
            this.errors.add(new ValidationError(String.format("References %s had targets in the graph but not in the model:\n%s", nodereferences.keySet(), nodereferences)));
        }
    }

    protected void filterFragmentBasedReferences(Set<String> noderefvaluesclone, Set<String> modelrefvaluesclone) {
        Iterator<String> itModelRefs = modelrefvaluesclone.iterator();
        block0: while (itModelRefs.hasNext()) {
            String modelref = itModelRefs.next();
            int idxHash = modelref.indexOf("#");
            String path = modelref.substring(modelref.indexOf("||||") + "||||".length(), idxHash);
            if (!path.equals("/*")) continue;
            String fragment = modelref.substring(idxHash + 1);
            Iterator<String> itNodeRefs = noderefvaluesclone.iterator();
            while (itNodeRefs.hasNext()) {
                String noderef = itNodeRefs.next();
                if (!noderef.endsWith("#" + fragment)) continue;
                itModelRefs.remove();
                itNodeRefs.remove();
                continue block0;
            }
        }
    }

    protected Map<String, Set<String>> computeNodeReferences(String repoURL, IGraphNode instance) {
        HashMap<String, Set<String>> nodeReferences = new HashMap<String, Set<String>>();
        for (IGraphEdge reference : instance.getOutgoing()) {
            if (reference.getType().equals("_hawkFile") || reference.getType().equals("_hawkOfType") || reference.getType().equals("_hawkOfKind") || reference.getPropertyKeys().contains("isDerived")) continue;
            Set refvals = nodeReferences.getOrDefault(reference.getType(), new HashSet());
            IGraphNode refEndNode = reference.getEndNode();
            String refEndNodeId = refEndNode.getProperty("_hawkid").toString();
            if (!this.singletonIndexIsEmpty && this.singletonIndex.get("id", (Object)refEndNodeId).iterator().hasNext()) {
                refvals.add(refEndNodeId);
            } else {
                IGraphNode targetFileNode = ((IGraphEdge)refEndNode.getOutgoingWithType("_hawkFile").iterator().next()).getEndNode();
                Object targetFileID = targetFileNode.getProperty("_hawkid");
                refvals.add(String.valueOf(repoURL) + "||||" + targetFileID + "#" + refEndNodeId);
            }
            nodeReferences.put(reference.getType(), refvals);
        }
        ModelElementNode men = new ModelElementNode(instance);
        for (ProxyReferenceList l : men.getProxies()) {
            for (ProxyReferenceList.ProxyReference proxyRef : l.getReferences()) {
                Set refvals = nodeReferences.getOrDefault(proxyRef.getEdgeLabel(), new HashSet());
                ProxyReferenceTarget target = proxyRef.getTarget();
                refvals.add(String.valueOf(target.getRepositoryURL()) + "||||" + "/" + target.getFilePath() + "#" + target.getFragment());
            }
        }
        return nodeReferences;
    }

    protected Map<String, Set<String>> computeModelReferences(URI tempURI, String repoURL, IHawkObject eobject) throws URISyntaxException {
        URI repoURI = new URI(repoURL);
        HashMap<String, Set<String>> modelReferences = new HashMap<String, Set<String>>();
        for (IHawkReference ref : ((IHawkClass)eobject.getType()).getAllReferences()) {
            if (!eobject.isSet((IHawkStructuralFeature)ref)) continue;
            Object refval = eobject.get(ref, false);
            HashSet<String> vals = new HashSet<String>();
            if (refval instanceof Iterable) {
                for (Object val : (Iterable)refval) {
                    vals.add(this.parseValue(val, repoURI, tempURI));
                }
            } else {
                vals.add(this.parseValue(refval, repoURI, tempURI));
            }
            if (vals.isEmpty()) continue;
            modelReferences.put(ref.getName(), vals);
        }
        return modelReferences;
    }

    protected void compareAttributes(IGraphNode node, IHawkObject modelElement) {
        HashMap<String, Object> modelAttributes = new HashMap<String, Object>();
        for (IHawkAttribute a : ((IHawkClass)modelElement.getType()).getAllAttributes()) {
            if (!modelElement.isSet((IHawkStructuralFeature)a)) continue;
            modelAttributes.put(a.getName(), modelElement.get(a));
        }
        for (String propertykey : node.getPropertyKeys()) {
            Object attr;
            if (propertykey.equals("_hawksignature") || propertykey.equals("_hawkid") || propertykey.startsWith("hawkProxyRef:") || propertykey.equals("h_lastDerived")) continue;
            List<Object> dbattr = node.getProperty(propertykey);
            if (!this.flattenedStringEquals(dbattr, attr = modelAttributes.get(propertykey))) {
                String dbJavaType = dbattr != null ? dbattr.getClass().toString() : "null attr";
                List<Object> dbValue = dbattr instanceof Object[] ? Arrays.asList((Object[])dbattr) : dbattr;
                String modelJavaType = attr != null ? attr.getClass().toString() : "null attr";
                Object modelValue = attr instanceof Object[] ? Arrays.asList((Object[])attr) : attr;
                this.errors.add(new ValidationError(String.format("Attribute %s has mismatched values:\n * database:\t%s JAVATYPE: %s IN NODE: %s WITH ID: %s\n * model:\t\t%s JAVATYPE: %s IN ELEMENT WITH ID %s", propertykey, dbValue, dbJavaType, node.getId(), node.getProperty("_hawkid"), modelValue, modelJavaType, modelElement.getUriFragment())));
            }
            modelAttributes.remove(propertykey);
        }
        if (modelAttributes.size() > 0) {
            this.errors.add(new ValidationError(String.format("The following attributes were not found in the graph node %s: %s", node.getId(), modelAttributes.keySet())));
        }
    }

    private String parseValue(Object val, URI repo, URI temp) throws URISyntaxException {
        String ret;
        IHawkObject o = (IHawkObject)val;
        if (!this.singletonIndexIsEmpty && this.singletonIndex.get("id", (Object)o.getUriFragment()).iterator().hasNext()) {
            ret = o.getUriFragment();
        } else {
            URI objURI = new URI(o.getUri());
            ret = objURI.getPath().replace(repo.getPath(), "").replace(temp.getPath(), "").replace("+", "%2B");
            if (objURI.getFragment() != null) {
                ret = String.valueOf(ret) + "#" + objURI.getFragment();
            }
            if (!ret.startsWith("/")) {
                ret = "/" + ret;
            }
            try {
                ret = URLDecoder.decode(ret, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret = repo + "||||" + ret;
        }
        return ret;
    }

    private int latestChangedElements() {
        return this.changed.size();
    }

    private int latestDeletedElements() {
        return this.deleted;
    }

    private Set<String> removeHawkProxies(IGraphNode instance, Set<String> modelrefvaluesclone) {
        for (String propertykey : instance.getPropertyKeys()) {
            if (!propertykey.startsWith("hawkProxyRef:")) continue;
            String[] proxies = (String[])instance.getProperty(propertykey);
            int i = 0;
            while (i < proxies.length) {
                if (modelrefvaluesclone.remove(proxies[i])) {
                    ++this.removedProxies;
                }
                i += 4;
            }
        }
        return modelrefvaluesclone;
    }

    private boolean flattenedStringEquals(Object dbattr, Object attr) {
        String newattr;
        String newdbattr;
        if (attr instanceof Float || attr instanceof Double) {
            return Math.abs(((Number)attr).doubleValue() - ((Number)dbattr).doubleValue()) < 1.0E-4;
        }
        String string = newdbattr = dbattr == null ? "null" : dbattr.toString();
        if (dbattr instanceof int[]) {
            newdbattr = Arrays.toString((int[])dbattr);
        } else if (dbattr instanceof long[]) {
            newdbattr = Arrays.toString((long[])dbattr);
        } else if (dbattr instanceof String[]) {
            newdbattr = Arrays.toString((String[])dbattr);
        } else if (dbattr instanceof boolean[]) {
            newdbattr = Arrays.toString((boolean[])dbattr);
        } else if (dbattr instanceof Object[]) {
            newdbattr = Arrays.toString((Object[])dbattr);
        }
        String string2 = newattr = attr == null ? "null" : attr.toString();
        if (attr instanceof int[]) {
            newattr = Arrays.toString((int[])attr);
        } else if (attr instanceof long[]) {
            newattr = Arrays.toString((long[])attr);
        } else if (attr instanceof String[]) {
            newattr = Arrays.toString((String[])attr);
        } else if (attr instanceof boolean[]) {
            newattr = Arrays.toString((boolean[])attr);
        } else if (attr instanceof Object[]) {
            newattr = Arrays.toString((Object[])attr);
        }
        return newdbattr.equals(newattr);
    }

    public void changeStart() {
    }

    public void changeSuccess() {
    }

    public void changeFailure() {
    }

    public void metamodelAddition(IHawkPackage pkg, IGraphNode pkgNode) {
    }

    public void classAddition(IHawkClass cls, IGraphNode clsNode) {
    }

    public void fileAddition(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void fileRemoval(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void modelElementAddition(VcsCommitItem s, IHawkObject element, IGraphNode elementNode, boolean isTransient) {
        this.changed.add(elementNode.getId().toString());
    }

    public void modelElementRemoval(VcsCommitItem s, IGraphNode elementNode, boolean isTransient) {
        ++this.deleted;
    }

    public void modelElementAttributeUpdate(VcsCommitItem s, IHawkObject eObject, String attrName, Object oldValue, Object newValue, IGraphNode elementNode, boolean isTransient) {
        this.changed.add(elementNode.getId().toString());
    }

    public void modelElementAttributeRemoval(VcsCommitItem s, IHawkObject eObject, String attrName, IGraphNode elementNode, boolean isTransient) {
        this.changed.add(elementNode.getId().toString());
    }

    public void referenceAddition(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        this.changed.add(source.getId().toString());
    }

    public void referenceRemoval(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        this.changed.add(source.getId().toString());
    }

    public class ValidationError {
        private final String message;

        public ValidationError(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

