/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetsFilter
extends ViewerFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ILaunchConfigurationType) {
            return true;
        }
        if (!(element instanceof ILaunchConfiguration)) return false;
        ILaunchConfiguration config = (ILaunchConfiguration)element;
        try {
            IResource[] resources = config.getMappedResources();
            if (resources == null) {
                return true;
            }
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return true;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return true;
            }
            IWorkingSet[] wsets = page.getWorkingSets();
            if (wsets.length < 1) {
                return true;
            }
            ArrayList<IWorkingSet> ws = new ArrayList<IWorkingSet>();
            IWorkingSet[] iWorkingSetArray = wsets;
            int n = wsets.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (!ws.isEmpty()) break;
                    return true;
                }
                IWorkingSet wset = iWorkingSetArray[n2];
                if (!"org.eclipse.debug.ui.breakpointWorkingSet".equals(wset.getId())) {
                    ws.add(wset);
                }
                ++n2;
            }
            iWorkingSetArray = resources;
            n = resources.length;
            n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IWorkingSet resource = iWorkingSetArray[n2];
                if (WorkingSetsFilter.workingSetContains(ws.toArray(new IWorkingSet[ws.size()]), (IResource)resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean workingSetContains(IWorkingSet[] wsets, IResource res) {
        ArrayList<IResource> parents = new ArrayList<IResource>();
        parents.add(res);
        while (res != null) {
            if ((res = res.getParent()) == null) continue;
            parents.add(res);
        }
        IResource lres = null;
        IWorkingSet[] iWorkingSetArray = wsets;
        int n = wsets.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable[] elements;
            IWorkingSet wset = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = elements = wset.getElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable element = iAdaptableArray[n4];
                lres = (IResource)element.getAdapter(IResource.class);
                if (lres != null && parents.contains(lres)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

