/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.reusable;

import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.AbstractJobListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SimpleJobListener
extends AbstractJobListener {
    private static final Logger logger = Logger.getLogger(SimpleJobListener.class.getName());
    @Inject
    private JobContext jobCtx = null;
    @Inject
    @BatchProperty(name="setTransientData")
    String setTransientDataString;

    public void beforeJob() throws Exception {
        if (this.setTransientDataString.equals("true")) {
            logger.fine("Setting transient data: ");
            this.jobCtx.setTransientUserData((Object)"FROM_BEFORE_JOB");
        } else {
            logger.fine("setTransientDataString prop = " + this.setTransientDataString + "; Not setting transient data.");
        }
    }

    public void afterJob() throws Exception {
        Object transientData = this.jobCtx.getTransientUserData();
        if (transientData instanceof String) {
            logger.fine("Found String transient data, setting into exit status");
            this.jobCtx.setExitStatus((String)transientData);
        } else {
            logger.fine("Found non-String transient data, leaving exit status alone");
        }
    }
}

