/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ArtifactInstanceTestJobListener
implements JobListener {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="job.property")
    String jobPropertyString;
    public static final String prop1 = "jobListenerA";
    public static final String prop2 = "jobListenerB";
    int instance1Count = 0;
    int instance2Count = 0;
    boolean saw2Listeners = false;
    boolean uniqueInstance1 = false;
    boolean uniqueInstance2 = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeJob() throws Exception {
        JobContext jobContext = this.jobCtx;
        synchronized (jobContext) {
            if (this.jobCtx.getTransientUserData() == null) {
                ConcurrentHashMap<String, Boolean> dataMap = new ConcurrentHashMap<String, Boolean>();
                dataMap.put("sawProp1", false);
                dataMap.put("sawProp2", false);
                this.jobCtx.setTransientUserData(dataMap);
            }
        }
        Map instanceData = (Map)this.jobCtx.getTransientUserData();
        if (this.jobPropertyString.equals(prop1)) {
            instanceData.put("sawProp1", true);
            ++this.instance1Count;
        } else if (this.jobPropertyString.equals(prop2)) {
            instanceData.put("sawProp2", true);
            ++this.instance2Count;
        }
    }

    public void afterJob() throws Exception {
        String currentStatus;
        Map instanceData = (Map)this.jobCtx.getTransientUserData();
        if (((Boolean)instanceData.get("sawProp1")).booleanValue() && ((Boolean)instanceData.get("sawProp2")).booleanValue()) {
            this.saw2Listeners = true;
        }
        if (this.jobPropertyString.equals(prop1) && this.instance1Count == 1) {
            this.uniqueInstance1 = true;
        }
        if (this.jobPropertyString.equals(prop2) && this.instance2Count == 1) {
            this.uniqueInstance2 = true;
        }
        if ((currentStatus = this.jobCtx.getExitStatus()) != null && currentStatus.equals("BAD")) {
            return;
        }
        if (this.saw2Listeners && this.uniqueInstance1 ^ this.uniqueInstance2) {
            this.jobCtx.setExitStatus(this.jobCtx.getExitStatus() + "JobListener");
        } else {
            this.jobCtx.setExitStatus("JOB_BAD");
        }
    }
}

