/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExecutionTests {
    private static final Logger logger = Logger.getLogger(ExecutionTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @AfterClass
    public static void cleanup() throws Exception {
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str));
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithOneBatchletStep() throws Exception {
        String METHOD = "testInvokeJobWithOneBatchletStep";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_1step.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithTwoStepSequenceOfBatchlets() throws Exception {
        String METHOD = "testInvokeJobWithTwoStepSequenceOfBatchlets";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_2steps.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_2steps");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithFourStepSequenceOfBatchlets() throws Exception {
        String METHOD = "testInvokeJobWithFourStepSequenceOfBatchlets";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithNextElement() throws Exception {
        String METHOD = "testInvokeJobWithNextElement";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_nextElement.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_nextElement");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithFailElement() throws Exception {
        String METHOD = "testInvokeJobWithFailElement";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_failElement.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("TEST_FAIL", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithStopElement() throws Exception {
        String METHOD = "testInvokeJobWithStopElement";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_stopElement.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_stopElement");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithEndElement() throws Exception {
        String METHOD = "testInvokeJobWithEndElement";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_endElement.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_endElement");
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("TEST_ENDED", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobSimpleChunk() throws Exception {
        String METHOD = "testInvokeJobSimpleChunk";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_chunk_simple.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_simple");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @org.junit.Test
    @Test(enabled=false)
    @Ignore(value="Bug 5379.  Decided to exclude this test.")
    public void testInvokeJobChunkWithFullAttributes() throws Exception {
        String METHOD = "testInvokeJobChunkWithFullAttributes";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_chunk_full_attributes.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_full_attributes");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobUsingTCCL() throws Exception {
        String METHOD = "testInvokeJobUsingTCCL";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Run job using job XML file: test_artifact_load_classloader<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("test_artifact_load_classloader");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testCheckpoint() throws Exception {
        String METHOD = "testCheckpoint";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_chunk_checkpoint.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_checkpoint");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testSimpleFlow() throws Exception {
        String METHOD = "testSimpleFlow";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_flow_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_flow_batchlet_4steps");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

