/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.junit.BeforeClass;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ParallelExecutionTests {
    private static final Logger logger = Logger.getLogger(ParallelExecutionTests.class.getName());
    private static final String TIME_TO_SLEEP_BEFORE_ISSUING_STOP = "1900";
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @AfterClass
    public static void cleanup() throws Exception {
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str + "<p>"));
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithOnePartitionedStep() throws Exception {
        String METHOD = "testInvokeJobWithOnePartitionedStep";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobWithOnePartitionedStepExitStatus() throws Exception {
        String METHOD = "testInvokeJobWithOnePartitionedStepExitStatus";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "2000";
        try {
            Properties jobParameters = new Properties();
            String sleepTime = System.getProperty("ParallelExecutionTests.testInvokeJobWithOnePartitionedStepExitStatus.sleep", DEFAULT_SLEEP_TIME);
            jobParameters.put("sleep.time", sleepTime);
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step_exitStatusTest", jobParameters);
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExecution.getExecutionId());
            AssertionUtils.assertObjEquals(1, stepExecutions.size());
            for (StepExecution stepEx : stepExecutions) {
                AssertionUtils.assertObjEquals("STEP EXIT STATUS: 10", stepEx.getExitStatus());
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, stepEx.getBatchStatus());
            }
            AssertionUtils.assertObjEquals("JOB EXIT STATUS: 10", jobExecution.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStopRunningPartitionedStep() throws Exception {
        String METHOD = "testStopRunningPartitionedStep";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_longrunning_partitioned.xml<p>");
            Reporter.log((String)"Create job parameters<p>");
            Properties overrideJobParams = new Properties();
            Reporter.log((String)"run.indefinitely=true<p>");
            overrideJobParams.setProperty("run.indefinitely", "true");
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult<p>");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning_partitioned", overrideJobParams);
            int sleepTime = Integer.parseInt(System.getProperty("ParallelExecutionTests.testStopRunningPartitionedStep.sleep", TIME_TO_SLEEP_BEFORE_ISSUING_STOP));
            Reporter.log((String)"Sleep for 1900");
            Thread.sleep(sleepTime);
            Reporter.log((String)"Invoke stopJobAndWaitForResult<p>");
            jobOp.stopJobAndWaitForResult(jobExecution);
            JobExecution jobExec2 = jobOp.getJobExecution(jobExecution.getExecutionId());
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExec2.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStopRestartRunningPartitionedStep() throws Exception {
        String METHOD = "testStopRestartRunningPartitionedStep";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_longrunning_partitioned.xml<p>");
            Reporter.log((String)"Create job parameters<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"run.indefinitely=true<p>");
            jobParams.setProperty("run.indefinitely", "true");
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult<p>");
            TCKJobExecutionWrapper origJobExecution = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning_partitioned", jobParams);
            int sleepTime = Integer.parseInt(System.getProperty("ParallelExecutionTests.testStopRestartRunningPartitionedStep.sleep", TIME_TO_SLEEP_BEFORE_ISSUING_STOP));
            Reporter.log((String)"Sleep for 1900");
            Thread.sleep(sleepTime);
            Reporter.log((String)"Invoke stopJobAndWaitForResult<p>");
            jobOp.stopJobAndWaitForResult(origJobExecution);
            JobExecution jobExec2 = jobOp.getJobExecution(origJobExecution.getExecutionId());
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExec2.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
            Reporter.log((String)"Create restart job parameters<p>");
            Properties restartJobParams = new Properties();
            Reporter.log((String)"run.indefinitely=true<p>");
            restartJobParams.setProperty("run.indefinitely", "false");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(origJobExecution.getExecutionId(), restartJobParams);
            Reporter.log((String)("JobExecution getBatchStatus()=" + restartedJobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, restartedJobExec.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testInvokeJobSimpleSplit() throws Exception {
        String METHOD = "testInvokeJobSimpleSplit";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_split_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_split_batchlet_4steps");
            Reporter.log((String)("JobExecution getBatchStatus()=" + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", execution.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPartitionedPlanCollectorAnalyzerReducerComplete() throws Exception {
        String METHOD = "testPartitionedPlanCollectorAnalyzerReducerComplete";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_artifacts.xml<p>");
            Reporter.log((String)"Create Job parameters for Execution #1<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"numPartitionsProp=3<p>");
            jobParams.setProperty("numPartitionsProp", "3");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            Reporter.log((String)("Execution exit status = " + execution.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACABeforeAfter", execution.getExitStatus());
            Reporter.log((String)("Execution status = " + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testZeroBasedPartitionedPlanCollectorAnalyzerReducerRollback() throws Exception {
        String METHOD = "testZeroBasedPartitionedPlanCollectorAnalyzerReducerRollback";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_artifacts.xml<p>");
            Reporter.log((String)"Create Job parameters for Execution #1<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"numPartitionsProp=3<p>");
            Reporter.log((String)"failThisPartition=0<p>");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            Reporter.log((String)("Execution exit status = " + execution.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            Reporter.log((String)("Execution status = " + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPartitionedCollectorAnalyzerReducerChunkRestartItemCount10() throws Exception {
        String METHOD = "testPartitionedCollectorAnalyzerReducerChunkRestartItemCount10";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"readrecord.fail=23<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=0,5,10,15,20,25,30<p>");
            jobParams.put("readrecord.fail", "23");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "20,30");
            Reporter.log((String)"Locate job XML file: chunkrestartPartitionedCheckpt10.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartPartitionedCheckpt10", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            int CA_PAIRS = 8;
            String CA = "CA";
            String expectedExitStatus = "null";
            expectedExitStatus = expectedExitStatus + "Begin";
            for (int i = 0; i < CA_PAIRS; ++i) {
                expectedExitStatus = expectedExitStatus + CA;
            }
            expectedExitStatus = expectedExitStatus + "Rollback";
            expectedExitStatus = expectedExitStatus + "After";
            AssertionUtils.assertWithMessage("Testing execution #1", expectedExitStatus, execution1.getExitStatus());
            long execution1Id = execution1.getExecutionId();
            long execution1InstanceId = execution1.getInstanceId();
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + execution1Id + "<p>"));
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution1Id, jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + execution2.getInstanceId() + "<p>"));
            Reporter.log((String)("execution #2 Job execution id=" + execution2.getExecutionId() + "<p>"));
            int CA_PAIRS2 = 4;
            String CA2 = "CA";
            String expectedExitStatus2 = "null";
            expectedExitStatus2 = expectedExitStatus2 + "Begin";
            for (int i = 0; i < CA_PAIRS2; ++i) {
                expectedExitStatus2 = expectedExitStatus2 + CA2;
            }
            expectedExitStatus2 = expectedExitStatus2 + "Before";
            expectedExitStatus2 = expectedExitStatus2 + "After";
            AssertionUtils.assertWithMessage("Testing execution #2 exit status", expectedExitStatus2, execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 batch status", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 instance ID", execution1InstanceId, execution2.getInstanceId());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPartitionedMapperOverrideFalseOnRestart() throws Exception {
        String METHOD = "testPartitionedMapperOverrideFalse";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_artifacts.xml<p>");
            Reporter.log((String)"Create Job parameters for Execution #1<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"numPartitionsProp=3<p>");
            Reporter.log((String)"failThisPartition=0<p>");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            Reporter.log((String)("Execution exit status = " + execution.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            Reporter.log((String)("Execution status = " + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            Reporter.log((String)"Set restart job parameters<p>");
            jobParams.setProperty("numPartitionsProp", "7");
            jobParams.setProperty("failThisPartition", "5");
            jobParams.setProperty("partitionsOverride", "false");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            Reporter.log((String)("Execution exit status = " + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCABeforeAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPartitionedMapperOverrideTrueDiffPartitionNumOnRestart() throws Exception {
        String METHOD = "testPartitionedMapperOverrideTrueDiffPartitionNumOnRestart";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_artifacts.xml<p>");
            Reporter.log((String)"Create Job parameters for Execution #1<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"numPartitionsProp=2<p>");
            Reporter.log((String)"failThisPartition=0<p>");
            jobParams.setProperty("numPartitionsProp", "2");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            Reporter.log((String)("Execution exit status = " + execution.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACARollbackAfter", execution.getExitStatus());
            Reporter.log((String)("Execution status = " + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            Reporter.log((String)"Set restart job parameters<p>");
            jobParams.setProperty("numPartitionsProp", "4");
            jobParams.setProperty("failThisPartition", "3");
            jobParams.setProperty("partitionsOverride", "true");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            Reporter.log((String)("Execution exit status = " + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACACARollbackAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testPartitionedMapperOverrideTrueSamePartitionNumOnRestart() throws Exception {
        String METHOD = "testPartitionedMapperOverrideTrueSamePartitionNumOnRestart";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_artifacts.xml<p>");
            Reporter.log((String)"Create Job parameters for Execution #1<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"numPartitionsProp=3<p>");
            Reporter.log((String)"failThisPartition=0<p>");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "0");
            jobParams.setProperty("partitionsOverride", "false");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_partitioned_artifacts", jobParams);
            Reporter.log((String)("Execution exit status = " + execution.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution.getExitStatus());
            Reporter.log((String)("Execution status = " + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, execution.getBatchStatus());
            Reporter.log((String)"Set restart job parameters<p>");
            jobParams.setProperty("numPartitionsProp", "3");
            jobParams.setProperty("failThisPartition", "1");
            jobParams.setProperty("partitionsOverride", "true");
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution.getExecutionId(), jobParams);
            Reporter.log((String)("Execution exit status = " + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("nullBeginCACACARollbackAfter", execution2.getExitStatus());
        }
        catch (Exception e) {
            ParallelExecutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

