/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import jakarta.validation.Valid;
import jakarta.validation.groups.ConvertGroup;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexChecks;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ConvertGroupDefaultFromTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConvertGroupDefaultFromTest.webArchiveBuilder().withTestClassPackage(ConvertGroupDefaultFromTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")
    public void testConvertGroupDefaultFromForProperty() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(BeanHolder.class, "property");
        Set groupConversionDescriptors = descriptor.getGroupConversions();
        GroupConversionDescriptor groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, Default.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexChecks.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")
    public void testConvertGroupDefaultFromForConstructorParameter() {
        ParameterDescriptor descriptor = (ParameterDescriptor)TestUtil.getConstructorDescriptor(BeanService.class, Bean.class).getParameterDescriptors().iterator().next();
        Set groupConversionDescriptors = descriptor.getGroupConversions();
        GroupConversionDescriptor groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, Default.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexChecks.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")
    public void testConvertGroupDefaultFromForMethodParameter() {
        ParameterDescriptor descriptor = (ParameterDescriptor)TestUtil.getMethodDescriptor(BeanService.class, "addBean", Bean.class).getParameterDescriptors().iterator().next();
        Set groupConversionDescriptors = descriptor.getGroupConversions();
        GroupConversionDescriptor groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, Default.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexChecks.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")
    public void testConvertGroupDefaultFromForMethodReturnValue() {
        ReturnValueDescriptor descriptor = TestUtil.getMethodDescriptor(BeanService.class, "getBean", new Class[0]).getReturnValueDescriptor();
        Set groupConversionDescriptors = descriptor.getGroupConversions();
        GroupConversionDescriptor groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, Default.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexChecks.class);
    }

    private GroupConversionDescriptor getGroupConversionDescriptorByFrom(Set<GroupConversionDescriptor> groupConversionDescriptors, Class<?> from) {
        Optional<GroupConversionDescriptor> groupConversionDescriptor = groupConversionDescriptors.stream().filter(gcd -> from.equals(gcd.getFrom())).findAny();
        return groupConversionDescriptor.orElseThrow(() -> new IllegalStateException(String.format("Unable to find group conversion with from %1$s in %2$s", from, groupConversionDescriptors)));
    }

    private static class BeanHolder {
        @Valid
        @ConvertGroup(to=ComplexChecks.class)
        private String property;

        private BeanHolder() {
        }
    }

    private static class BeanService {
        public BeanService(@Valid @ConvertGroup(to=ComplexChecks.class) Bean bean) {
        }

        @Valid
        @ConvertGroup(to=ComplexChecks.class)
        public Bean getBean() {
            return null;
        }

        public void addBean(@Valid @ConvertGroup(to=ComplexChecks.class) Bean bean) {
        }
    }

    private static class Bean {
        private Bean() {
        }
    }
}

