/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.dd;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorTestBeanInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.testng.Assert;

@WebServlet(value={"/DeploymentDescriptorServlet"})
public class DeploymentDescriptorServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @EJB
    DeploymentDescriptorTestBeanInterface enterpriseBean;
    @Resource
    UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeploymentDescriptorDefinesContextService() throws Throwable {
        int status;
        Callable checkContextAndGetTransactionStatus;
        ContextService contextSvc = (ContextService)InitialContext.doLookup("java:global/concurrent/ContextD");
        this.tx.begin();
        try {
            IntContext.set(1001);
            StringContext.set("testDeploymentDescriptorDefinesContextService-1");
            checkContextAndGetTransactionStatus = contextSvc.contextualCallable(() -> {
                Assert.assertEquals((int)IntContext.get(), (int)0);
                Assert.assertEquals((String)StringContext.get(), (String)"testDeploymentDescriptorDefinesContextService-1");
                Assert.assertNotNull(InitialContext.doLookup("java:app/concurrent/ExecutorD"));
                return this.tx.getStatus();
            });
            StringContext.set("testDeploymentDescriptorDefinesContextService-2");
            status = (Integer)checkContextAndGetTransactionStatus.call();
            Assert.assertEquals((int)status, (int)0);
            Assert.assertEquals((int)IntContext.get(), (int)1001);
            Assert.assertEquals((String)StringContext.get(), (String)"testDeploymentDescriptorDefinesContextService-2");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
            this.tx.rollback();
        }
        status = (Integer)checkContextAndGetTransactionStatus.call();
        Assert.assertEquals((int)status, (int)6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeploymentDescriptorDefinesManagedExecutor() throws Throwable {
        LinkedBlockingQueue started = new LinkedBlockingQueue();
        CountDownLatch taskCanEnd = new CountDownLatch(1);
        Supplier<String> task = () -> {
            try {
                started.add(InitialContext.doLookup("java:app/concurrent/ExecutorD"));
                Assert.assertTrue((boolean)taskCanEnd.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
            return StringContext.get();
        };
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorD");
        try {
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-1");
            CompletableFuture future1 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-2");
            CompletableFuture future2 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-3");
            CompletableFuture future3 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-4");
            CompletableFuture future4 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-5");
            Assert.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assert.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assert.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assert.assertEquals(started.poll(1L, TimeUnit.SECONDS), null);
            taskCanEnd.countDown();
            Assert.assertEquals((String)((String)future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"testDeploymentDescriptorDefinesManagedExecutor-1");
            Assert.assertEquals((String)((String)future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"testDeploymentDescriptorDefinesManagedExecutor-2");
            Assert.assertEquals((String)((String)future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"testDeploymentDescriptorDefinesManagedExecutor-3");
            Assert.assertEquals((String)((String)future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"testDeploymentDescriptorDefinesManagedExecutor-4");
            Assert.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    public void testDeploymentDescriptorDefinesManagedScheduledExecutor() throws Throwable {
        this.enterpriseBean.testDeploymentDescriptorDefinesManagedScheduledExecutor();
    }

    public void testDeploymentDescriptorDefinesManagedThreadFactory() throws Throwable {
        this.enterpriseBean.testDeploymentDescriptorDefinesManagedThreadFactory();
    }
}

