/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.virtual;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.servlet.annotation.WebServlet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

@ManagedExecutorDefinition.List(value={@ManagedExecutorDefinition(name="java:app/concurrent/ManagedExecutorAnnoPlatform", virtual=false), @ManagedExecutorDefinition(name="java:app/concurrent/ManagedExecutorAnnoVirtual", virtual=true)})
@ManagedScheduledExecutorDefinition.List(value={@ManagedScheduledExecutorDefinition(name="java:app/concurrent/ManagedScheduledExecutorAnnoPlatform", virtual=false), @ManagedScheduledExecutorDefinition(name="java:app/concurrent/ManagedScheduledExecutorAnnoVirtual", virtual=true)})
@ManagedThreadFactoryDefinition.List(value={@ManagedThreadFactoryDefinition(name="java:app/concurrent/ThreadFactoryAnnoPlatform", virtual=false), @ManagedThreadFactoryDefinition(name="java:app/concurrent/ThreadFactoryAnnoVirtual", virtual=true)})
@WebServlet(value={"/VirtualThreadServlet"})
public class VirtualThreadServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final TestLogger log = TestLogger.get(VirtualThreadServlet.class);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private static final int VERSION = Runtime.version().feature();

    public void testPlatformExecutor() throws Exception {
        ManagedExecutorService platformManagedExecutorAnno = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedExecutorAnnoPlatform");
        ManagedExecutorService platformManagedExecutorDD = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedExecutorDDPlatform");
        Assertions.assertNotNull((Object)platformManagedExecutorAnno);
        Assertions.assertNotNull((Object)platformManagedExecutorDD);
        Thread annoThread = (Thread)platformManagedExecutorAnno.submit(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        Thread ddThread = (Thread)platformManagedExecutorDD.submit(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(annoThread));
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(ddThread));
    }

    public void testVirtualExecutor() throws Exception {
        ManagedExecutorService virtualManagedExecutorAnno = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedExecutorAnnoVirtual");
        ManagedExecutorService virtualManagedExecutorDD = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedExecutorDDVirtual");
        Assertions.assertNotNull((Object)virtualManagedExecutorAnno);
        Assertions.assertNotNull((Object)virtualManagedExecutorDD);
        Thread annoThread = (Thread)virtualManagedExecutorAnno.supplyAsync(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        Thread ddThread = (Thread)virtualManagedExecutorDD.supplyAsync(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(annoThread), () -> {
            List results = virtualManagedExecutorAnno.invokeAll(List.of(new LookupActionCaptureThread(null, "java:app/concurrent/ManagedExecutorAnnoVirtual"), new LookupActionCaptureThread(null, "java:app/concurrent/ManagedExecutorAnnoVirtual"), new LookupActionCaptureThread(null, "java:app/concurrent/ManagedExecutorAnnoVirtual")), TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
            Assertions.assertEquals((int)3, (int)results.size());
            Object result0 = ((Future)results.get(0)).get(1L, TimeUnit.MILLISECONDS);
            Object result1 = ((Future)results.get(1)).get(1L, TimeUnit.MILLISECONDS);
            Object result2 = ((Future)results.get(2)).get(1L, TimeUnit.MILLISECONDS);
            HashSet<Thread> virtualThreads = new HashSet<Thread>();
            Assertions.assertNotNull(result0);
            if (result0 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result0);
            }
            if (VirtualThreadServlet.isVirtual((Thread)result0)) {
                virtualThreads.add((Thread)result0);
            }
            Assertions.assertNotNull(result1);
            if (result1 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result1);
            }
            if (VirtualThreadServlet.isVirtual((Thread)result1)) {
                virtualThreads.add((Thread)result1);
            }
            Assertions.assertNotNull(result2);
            if (result2 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result2);
            }
            if (VirtualThreadServlet.isVirtual((Thread)result2)) {
                virtualThreads.add((Thread)result2);
            }
            log.info("ManagedExecutorService.invokeAll() resulted in " + virtualThreads.size() + " out of 3 tasks were run on virtual threads.");
        });
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(ddThread), () -> {
            Object result = virtualManagedExecutorDD.invokeAny(List.of(new LookupActionCaptureThread(null, "java:app/concurrent/ManagedExecutorDDVirtual"), new LookupActionCaptureThread(null, "java:app/concurrent/ManagedExecutorDDVirtual")));
            Assertions.assertNotNull((Object)result);
            if (result instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result);
            }
            if (VirtualThreadServlet.isVirtual((Thread)result)) {
                log.info("ManagedExecutorService.invokeAny() resulted in task being run on a virtual thread.");
            }
        });
    }

    public void testPlatformScheduledExecutor() throws Exception {
        ManagedScheduledExecutorService platformManagedScheduledExecutorAnno = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedScheduledExecutorAnnoPlatform");
        ManagedScheduledExecutorService platformManagedScheduledExecutorDD = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedScheduledExecutorDDPlatform");
        Assertions.assertNotNull((Object)platformManagedScheduledExecutorAnno);
        Assertions.assertNotNull((Object)platformManagedScheduledExecutorDD);
        Thread annoThread = (Thread)platformManagedScheduledExecutorAnno.submit(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        Thread ddThread = (Thread)platformManagedScheduledExecutorDD.submit(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(annoThread));
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(ddThread));
    }

    public void testVirtualScheduledExecutor() throws Exception {
        ManagedScheduledExecutorService virtualManagedScheduledExecutorAnno = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedScheduledExecutorAnnoVirtual");
        ManagedScheduledExecutorService virtualManagedScheduledExecutorDD = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ManagedScheduledExecutorDDVirtual");
        Assertions.assertNotNull((Object)virtualManagedScheduledExecutorAnno);
        Assertions.assertNotNull((Object)virtualManagedScheduledExecutorDD);
        Thread annoThread = (Thread)virtualManagedScheduledExecutorAnno.supplyAsync(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        Thread ddThread = (Thread)virtualManagedScheduledExecutorDD.supplyAsync(Thread::currentThread).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(ddThread), () -> {
            LinkedBlockingQueue<Object> results = new LinkedBlockingQueue<Object>();
            ScheduledFuture oneTimeFuture = virtualManagedScheduledExecutorDD.schedule((Runnable)new LookupActionCaptureThread(results, "java:app/concurrent/ManagedScheduledExecutorDDVirtual"), TestConstants.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
            Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
                while (2 != results.size()) {
                    Wait.sleep(TestConstants.pollInterval);
                }
            });
            Assertions.assertTrue((boolean)oneTimeFuture.isDone());
            Assertions.assertEquals((int)2, (int)results.size());
            Thread thread = (Thread)results.poll(1L, TimeUnit.MILLISECONDS);
            Object result = results.poll(1L, TimeUnit.MILLISECONDS);
            if (result instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result);
            }
            if (VirtualThreadServlet.isVirtual(thread)) {
                log.info("ManagedScheduledExecutorService.schedule() resulted in task being run on a virtual thread.");
            }
        });
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(annoThread), () -> {
            LinkedBlockingQueue<Object> resultsFixedRate = new LinkedBlockingQueue<Object>();
            ScheduledFuture future = virtualManagedScheduledExecutorAnno.scheduleAtFixedRate((Runnable)new LookupActionCaptureThread(resultsFixedRate, "java:app/concurrent/ManagedScheduledExecutorAnnoVirtual"), 0L, TestConstants.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
            Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
                while (6 >= resultsFixedRate.size()) {
                    Wait.sleep(TestConstants.pollInterval);
                }
            });
            Wait.waitCancelFuture(future);
            int resultsAfterCancel = resultsFixedRate.size();
            Assertions.assertTrue((resultsAfterCancel >= 6 ? 1 : 0) != 0, (String)"Should have executed schedule at least 3 times.");
            Thread thread0 = (Thread)resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Object result0 = resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Thread thread1 = (Thread)resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Object result1 = resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Thread thread2 = (Thread)resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Object result2 = resultsFixedRate.poll(1L, TimeUnit.MILLISECONDS);
            Assertions.assertEquals((int)(resultsAfterCancel - 6), (int)resultsFixedRate.size(), (String)"No more results should have been added to queue after task was cancelled");
            HashSet<Thread> virtualThreads = new HashSet<Thread>();
            if (result0 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result0);
            }
            if (VirtualThreadServlet.isVirtual(thread0)) {
                virtualThreads.add(thread0);
            }
            if (result1 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result1);
            }
            if (VirtualThreadServlet.isVirtual(thread1)) {
                virtualThreads.add(thread1);
            }
            if (result2 instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result2);
            }
            if (VirtualThreadServlet.isVirtual(thread2)) {
                virtualThreads.add(thread2);
            }
            log.info("ManagedScheduledExecutorService.scheduleAtFixedRate() resulted in " + virtualThreads.size() + " out of 3 tasks were run on virtual threads.");
        });
    }

    public void testPlatformThreadFactory() throws Exception {
        ManagedThreadFactory platformThreadFactoryAnno = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryAnnoPlatform");
        ManagedThreadFactory platformThreadFactoryDD = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryDDPlatform");
        Assertions.assertNotNull((Object)platformThreadFactoryAnno);
        Assertions.assertNotNull((Object)platformThreadFactoryDD);
        Thread annoThread = platformThreadFactoryAnno.newThread(NOOP_RUNNABLE);
        Thread ddThread = platformThreadFactoryDD.newThread(NOOP_RUNNABLE);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(annoThread), (String)"Thread Factory should not have returned a virtual thread when defined with virtual=false");
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(ddThread), (String)"Thread Factory should not have returned a virtual thread when defined with virtual=false");
    }

    public void testVirtualThreadFactory() throws Exception {
        ManagedThreadFactory virtualThreadFactoryAnno = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryAnnoVirtual");
        ManagedThreadFactory virtualThreadFactoryDD = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryDDVirtual");
        Assertions.assertNotNull((Object)virtualThreadFactoryAnno);
        Assertions.assertNotNull((Object)virtualThreadFactoryDD);
        Thread annoThread = virtualThreadFactoryAnno.newThread(NOOP_RUNNABLE);
        Thread ddThread = virtualThreadFactoryDD.newThread(NOOP_RUNNABLE);
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(annoThread), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(ddThread), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(annoThread), () -> {
            LinkedBlockingQueue<Object> results = new LinkedBlockingQueue<Object>();
            Thread thread1 = virtualThreadFactoryAnno.newThread((Runnable)new LookupAction(results, "java:app/concurrent/ThreadFactoryAnnoVirtual"));
            thread1.start();
            Object result = results.poll(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)result);
            if (result instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result);
            }
        });
        Assumptions.assumingThat((boolean)VirtualThreadServlet.isVirtual(ddThread), () -> {
            LinkedBlockingQueue<Object> results = new LinkedBlockingQueue<Object>();
            Thread thread2 = virtualThreadFactoryDD.newThread((Runnable)new LookupAction(results, "java:app/concurrent/ThreadFactoryDDVirtual"));
            thread2.start();
            Object result = results.poll(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)result);
            if (result instanceof Throwable) {
                throw new AssertionError("An error occured on thread.", (Throwable)result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVirtualThreadFactoryForkJoinPool() throws Exception {
        Thread thread2;
        Thread thread1;
        ManagedThreadFactory virtualThreadFactoryAnno = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryAnnoVirtual");
        ManagedThreadFactory platformThreadFactoryAnno = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryAnnoPlatform");
        Assertions.assertNotNull((Object)virtualThreadFactoryAnno);
        Assertions.assertNotNull((Object)platformThreadFactoryAnno);
        ForkJoinPool virtualPool = new ForkJoinPool(3, (ForkJoinPool.ForkJoinWorkerThreadFactory)virtualThreadFactoryAnno, null, false);
        try {
            thread1 = (Thread)((ForkJoinTask)virtualPool.submit(Thread::currentThread)).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            virtualPool.shutdown();
        }
        ForkJoinPool platformPool = new ForkJoinPool(3, (ForkJoinPool.ForkJoinWorkerThreadFactory)platformThreadFactoryAnno, null, false);
        try {
            thread2 = (Thread)((ForkJoinTask)platformPool.submit(Thread::currentThread)).get(TestConstants.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            platformPool.shutdown();
        }
        if (VERSION == 17) {
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(thread1), (String)"Should be impossible to get a virtual thread on Java 17");
            Assertions.assertThrows(NoSuchMethodException.class, () -> VirtualThreadServlet.isVirtual(thread2), (String)"Should be impossible to get a virtual thread on Java 17");
            return;
        }
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(thread1), (String)"Should never get a virtual thread from a ForkJoinPool");
        Assertions.assertFalse((boolean)VirtualThreadServlet.isVirtual(thread2), (String)"Should never get a virtual thread from a ForkJoinPool");
    }

    private static boolean isVirtual(Thread thread) throws NoSuchMethodException {
        Method isVirtual = Thread.class.getMethod("isVirtual", new Class[0]);
        isVirtual.setAccessible(true);
        try {
            return (Boolean)isVirtual.invoke((Object)thread, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Could not invoke isVirtual on thread: " + thread.getName(), e);
        }
    }

    public class LookupAction
    implements Runnable,
    Callable<Object> {
        private BlockingQueue<Object> results;
        private String resource;

        public LookupAction(BlockingQueue<Object> results, String resource) {
            this.results = results;
            this.resource = resource;
        }

        @Override
        public void run() {
            try {
                this.results.add(InitialContext.doLookup(this.resource));
            }
            catch (Throwable x) {
                this.results.add(x);
            }
        }

        @Override
        public Object call() throws Exception {
            try {
                return InitialContext.doLookup(this.resource);
            }
            catch (Throwable x) {
                return x;
            }
        }

        public BlockingQueue<Object> getResults() {
            return this.results;
        }

        public String getResource() {
            return this.resource;
        }
    }

    public class LookupActionCaptureThread
    extends LookupAction {
        public LookupActionCaptureThread(BlockingQueue<Object> results, String resource) {
            super(results, resource);
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            this.getResults().add(thread);
            super.run();
        }

        @Override
        public Object call() throws Exception {
            try {
                InitialContext.doLookup(this.getResource());
            }
            catch (Throwable x) {
                return x;
            }
            return Thread.currentThread();
        }
    }
}

