/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.virtual;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.spec.Platform.virtual.VirtualThreadServlet;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Web
@RunAsClient
public class VirtualWebTests
extends TestClient {
    @ArquillianResource(value=VirtualThreadServlet.class)
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="VirtualThreadTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"VirtualTests_web.war")).addPackages(false, new Package[]{VirtualWebTests.class.getPackage()})).addAsWebInfResource(VirtualWebTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Override
    protected String getServletPath() {
        return "VirtualThreadServlet";
    }

    @Assertion(id="GIT:414", strategy="Tests that a managed executor with virtual = false never uses a virtual thread.")
    public void testPlatformExecutor() throws Exception {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a managed executor with virtual = true can use a virtual thread, or returns a platform thread if it is not capable of providing virtual threads.")
    public void testVirtualExecutor() throws Exception {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a managed scheduled executor with virtual = false never uses a virtual thread.")
    public void testPlatformScheduledExecutor() throws Exception {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a managed scheduled executor with virtual = true can use a virtual thread, or returns a platform thread if it is not capable of providing virtual threads.")
    public void testVirtualScheduledExecutor() throws Exception {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a thread factory with virtual = false never returns a virtual thread.")
    public void testPlatformThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a thread factory with virtual = true can return and use a virtual thread, or returns a platform thread if it is not capable of providing virtual threads.")
    public void testVirtualThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:414", strategy="Tests that a ForkJoinPool created from a thread factory with virtual = true can return and use a virtual thread, or returns a platform thread if it is not capable of providing virtual threads.")
    public void testVirtualThreadFactoryForkJoinPool() {
        this.runTest(this.baseURL, this.testname);
    }
}

