/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.util;

public class Reflection {
    public static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.cast(clazz.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot find public default constructor: " + clazz.getName());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to create instance", e);
        }
    }

    public static <T> Class<T> loadClass(String fqcn) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find class: " + fqcn);
        }
    }
}

