/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EndInteractiveTransactionExtendedRequest
extends ExtendedRequest {
    public static final String END_INTERACTIVE_TRANSACTION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.4";
    private static final byte TYPE_TXN_ID = -128;
    private static final byte TYPE_COMMIT = -127;
    private static final long serialVersionUID = -7404929482337917353L;
    private final ASN1OctetString transactionID;
    private final boolean commit;

    public EndInteractiveTransactionExtendedRequest(ASN1OctetString transactionID, boolean commit) {
        this(transactionID, commit, null);
    }

    public EndInteractiveTransactionExtendedRequest(ASN1OctetString transactionID, boolean commit, Control[] controls) {
        super(END_INTERACTIVE_TRANSACTION_REQUEST_OID, EndInteractiveTransactionExtendedRequest.encodeValue(transactionID, commit), controls);
        this.transactionID = transactionID;
        this.commit = commit;
    }

    public EndInteractiveTransactionExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_INT_TXN_REQUEST_NO_VALUE.get());
        }
        ASN1OctetString txnID = null;
        boolean shouldCommit = true;
        try {
            ASN1Element[] elements;
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(valueElement).elements()) {
                if (e.getType() == -128) {
                    txnID = ASN1OctetString.decodeAsOctetString(e);
                    continue;
                }
                if (e.getType() == -127) {
                    shouldCommit = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_INT_TXN_REQUEST_INVALID_TYPE.get(StaticUtils.toHex(e.getType())));
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_INT_TXN_REQUEST_CANNOT_DECODE.get(e), e);
        }
        if (txnID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_INT_TXN_REQUEST_NO_TXN_ID.get());
        }
        this.transactionID = txnID;
        this.commit = shouldCommit;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString transactionID, boolean commit) {
        Validator.ensureNotNull(transactionID);
        ASN1Element[] valueElements = commit ? new ASN1Element[]{new ASN1OctetString(-128, transactionID.getValue())} : new ASN1Element[]{new ASN1OctetString(-128, transactionID.getValue()), new ASN1Boolean(-127, commit)};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public boolean commit() {
        return this.commit;
    }

    @Override
    public EndInteractiveTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public EndInteractiveTransactionExtendedRequest duplicate(Control[] controls) {
        EndInteractiveTransactionExtendedRequest r = new EndInteractiveTransactionExtendedRequest(this.transactionID, this.commit, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_END_INTERACTIVE_TXN.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("EndInteractiveTransactionExtendedRequest(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("', commit=");
        buffer.append(this.commit);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

