/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AddRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -1195296296055518601L;
    private final List<Attribute> attributes;
    private final String dn;

    public AddRequestProtocolOp(String dn, List<Attribute> attributes) {
        this.dn = dn;
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public AddRequestProtocolOp(AddRequest request) {
        this.dn = request.getDN();
        this.attributes = request.getAttributes();
    }

    AddRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence attrSequence = reader.beginSequence();
            while (attrSequence.hasMoreElements()) {
                attrs.add(Attribute.readFrom(reader));
            }
            this.attributes = Collections.unmodifiableList(attrs);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ADD_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getProtocolOpType() {
        return 104;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(this.attributes.size());
        for (Attribute a : this.attributes) {
            attrElements.add(a.encode());
        }
        return new ASN1Sequence(104, new ASN1OctetString(this.dn), new ASN1Sequence(attrElements));
    }

    public static AddRequestProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(attrElements.length);
            for (ASN1Element ae : attrElements) {
                attributes.add(Attribute.decode(ASN1Sequence.decodeAsSequence(ae)));
            }
            return new AddRequestProtocolOp(dn, attributes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ADD_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)104);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence attrSequence = buffer.beginSequence();
        for (Attribute a : this.attributes) {
            a.writeTo(buffer);
        }
        attrSequence.end();
        opSequence.end();
    }

    public AddRequest toAddRequest(Control ... controls) {
        return new AddRequest(this.dn, this.attributes, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AddRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', attrs={");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

