/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.CookieManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.HeaderFilter;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.Response;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Log;

class CookieFilter
implements HeaderFilter {
    @Override
    public void request(HttpRequestImpl httpRequestImpl, MultiExchange<?, ?> multiExchange) throws IOException {
        HttpClientImpl httpClientImpl = multiExchange.client();
        Optional<CookieManager> optional = httpClientImpl.cookieManager();
        if (optional.isPresent()) {
            CookieManager cookieManager = optional.get();
            Map<String, List<String>> map = httpRequestImpl.getUserHeaders().map();
            Map<String, List<String>> map2 = cookieManager.get(httpRequestImpl.uri(), map);
            HttpHeadersImpl httpHeadersImpl = httpRequestImpl.getSystemHeaders();
            if (map2.isEmpty()) {
                Log.logTrace("Request: no cookie to add for {0}", httpRequestImpl.uri());
            } else {
                Log.logTrace("Request: adding cookies for {0}", httpRequestImpl.uri());
            }
            for (String string : map2.keySet()) {
                List<String> list = map2.get(string);
                for (String string2 : list) {
                    httpHeadersImpl.addHeader(string, string2);
                }
            }
        } else {
            Log.logTrace("Request: No cookie manager found for {0}", httpRequestImpl.uri());
        }
    }

    @Override
    public HttpRequestImpl response(Response response) throws IOException {
        HttpHeaders httpHeaders = response.headers();
        HttpRequestImpl httpRequestImpl = response.request();
        Exchange<?> exchange = response.exchange;
        Log.logTrace("Response: processing cookies for {0}", httpRequestImpl.uri());
        Optional<CookieManager> optional = exchange.client().cookieManager();
        if (optional.isPresent()) {
            CookieManager cookieManager = optional.get();
            Log.logTrace("Response: parsing cookies from {0}", httpHeaders.map());
            cookieManager.put(httpRequestImpl.uri(), httpHeaders.map());
        } else {
            Log.logTrace("Response: No cookie manager found for {0}", httpRequestImpl.uri());
        }
        return null;
    }
}

